/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools;

import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.networking.DoneableNetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DoneableRoute;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftUtils.class);
    private OpenShiftClient client;

    public OpenShiftUtils(OpenShiftClient client) {
        this.client = client;
    }

    public Route createRoute(String project, String name, String service, String port, Map<String, String> labels) {
        Route route = ((DoneableRoute)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((DoneableRoute)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)((DoneableRoute)((NonNamespaceOperation)this.client.routes().inNamespace(project)).createOrReplaceWithNew()).withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).withNewSpec().withNewTo().withKind("Service")).withName(service)).endTo()).withNewPort().withNewTargetPort(port)).endPort()).endSpec()).done();
        return route;
    }

    public NetworkPolicy createNetworkPolicy(String project, String name, Map<String, String> podSelectorLabels, List<NetworkPolicyPort> ports) {
        NetworkPolicy policy = ((DoneableNetworkPolicy)((NetworkPolicyFluent.SpecNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((DoneableNetworkPolicy)((NetworkPolicyFluent.MetadataNested)((DoneableNetworkPolicy)((NonNamespaceOperation)this.client.network().networkPolicies().inNamespace(project)).createOrReplaceWithNew()).withNewMetadata().withName(name)).endMetadata()).withNewSpec().withNewPodSelector().withMatchLabels(podSelectorLabels)).endPodSelector()).addNewIngress().addToPorts(ports.toArray(new NetworkPolicyPort[ports.size()]))).endIngress()).withPolicyTypes(new String[]{"Ingress"})).endSpec()).done();
        return policy;
    }

    public ServiceAccount linkPullSecret(String project, String sa, String secret) {
        return ((DoneableServiceAccount)((DoneableServiceAccount)((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(project)).withName(sa)).edit()).addNewImagePullSecret(secret)).done();
    }

    public PodList podsWithLabels(String project, Map<String, String> labels) {
        Supplier<PodList> podListSupplier = () -> (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(project)).withLabels(labels)).list();
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).until(() -> ((PodList)podListSupplier.get()).getItems().size() > 0);
        PodList pods = podListSupplier.get();
        if (pods.getItems().isEmpty()) {
            LOGGER.warn("Empty PodList");
        }
        return pods;
    }

    public void waitForPods(String project, Map<String, String> labels) {
        String lbls = labels.keySet().stream().map(k -> k + "=" + (String)labels.get(k)).collect(Collectors.joining(", "));
        LOGGER.info("Waiting for pods to deploy [" + lbls + "]");
        PodList pods = this.podsWithLabels(project, labels);
        for (Pod p : pods.getItems()) {
            try {
                this.client.resource((HasMetadata)p).waitUntilReady(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Error when waiting for pod " + p.getMetadata().getName() + " to get ready", e);
            }
        }
    }
}

