/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift;

import io.debezium.testing.openshift.TestUtils;
import io.debezium.testing.openshift.resources.ConfigProperties;
import io.debezium.testing.openshift.tools.kafka.KafkaConnectController;
import io.debezium.testing.openshift.tools.kafka.KafkaController;
import io.debezium.testing.openshift.tools.kafka.KafkaDeployer;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectorTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorTestBase.class);
    public static final String KAFKA = "/kafka-resources/010-kafka.yaml";
    public static final String KAFKA_CONNECT_S2I_LOGGING = "/kafka-resources/020-kafka-connect-logging.yaml";
    public static final String KAFKA_CONNECT_S2I = "/kafka-resources/021-kafka-connect.yaml";
    protected static Properties KAFKA_CONSUMER_PROPS = new Properties();
    protected static OpenShiftClient ocp;
    protected static TestUtils testUtils;
    protected static KafkaDeployer kafkaDeployer;
    protected static KafkaController kafkaController;
    protected static KafkaConnectController kafkaConnectController;

    @BeforeAll
    public static void setup() throws InterruptedException {
        Config cfg = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(ConfigProperties.OCP_URL)).withUsername(ConfigProperties.OCP_USERNAME)).withPassword(ConfigProperties.OCP_PASSWORD)).withTrustCerts(true)).build();
        ocp = new DefaultOpenShiftClient(cfg);
        testUtils = new TestUtils();
        kafkaDeployer = new KafkaDeployer(ConfigProperties.OCP_PROJECT_DBZ, ocp);
        ConfigProperties.OCP_SECRET_RHIO_PATH.ifPresent(arg_0 -> ((KafkaDeployer)kafkaDeployer).deployPullSecret(arg_0));
        kafkaController = kafkaDeployer.deployKafkaCluster(KAFKA);
        kafkaConnectController = kafkaDeployer.deployKafkaConnectCluster(KAFKA_CONNECT_S2I, KAFKA_CONNECT_S2I_LOGGING, ConfigProperties.STRIMZI_OPERATOR_CONNECTORS);
        kafkaConnectController.allowServiceAccess();
        kafkaConnectController.exposeApi();
        kafkaConnectController.exposeMetrics();
        KAFKA_CONSUMER_PROPS.put("bootstrap.servers", kafkaController.getKafkaBootstrapAddress());
        KAFKA_CONSUMER_PROPS.put("key.deserializer", StringDeserializer.class);
        KAFKA_CONSUMER_PROPS.put("value.deserializer", StringDeserializer.class);
        KAFKA_CONSUMER_PROPS.put("group.id", "DEBEZIUM_IT_01");
        KAFKA_CONSUMER_PROPS.put("auto.offset.reset", "earliest");
        KAFKA_CONSUMER_PROPS.put("enable.auto.commit", (Object)false);
    }

    protected void assertTopicsExist(String ... names) {
        try (KafkaConsumer consumer = new KafkaConsumer(KAFKA_CONSUMER_PROPS);){
            Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> ConnectorTestBase.lambda$assertTopicsExist$0((Consumer)consumer, names));
        }
    }

    protected void assertRecordsCount(String topic, int count) {
        try (KafkaConsumer consumer = new KafkaConsumer(KAFKA_CONSUMER_PROPS);){
            consumer.subscribe(Collections.singleton(topic));
            ConsumerRecords records = consumer.poll(Duration.of(10L, ChronoUnit.SECONDS));
            consumer.seekToBeginning((Collection)consumer.assignment());
            Assertions.assertThat((int)records.count()).isEqualTo(count);
        }
    }

    private static /* synthetic */ void lambda$assertTopicsExist$0(Consumer consumer, String[] names) throws Throwable {
        Set topics = consumer.listTopics().keySet();
        Assertions.assertThat(topics).contains((Object[])names);
    }
}

