/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.mysql;

import io.debezium.testing.openshift.ConnectorTestBase;
import io.debezium.testing.openshift.resources.ConfigProperties;
import io.debezium.testing.openshift.resources.ConnectorFactories;
import io.debezium.testing.openshift.tools.databases.MySqlDeployer;
import io.debezium.testing.openshift.tools.kafka.ConnectorConfigBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@Tags(value={@Tag(value="acceptance"), @Tag(value="mysql")})
public class MySqlConnectorIT
extends ConnectorTestBase {
    public static final String DB_DEPLOYMENT_PATH = "/database-resources/mysql/deployment.yaml";
    public static final String DB_SERVICE_PATH_LB = "/database-resources/mysql/service-lb.yaml";
    public static final String DB_SERVICE_PATH = "/database-resources/mysql/service.yaml";
    public static final String CONNECTOR_NAME = "inventory-connector-mysql";
    private static MySqlDeployer dbDeployer;
    private static OkHttpClient httpClient;
    private static ConnectorFactories connectorFactories;
    private static String connectorName;

    @BeforeAll
    public static void setupDatabase() throws IOException, InterruptedException {
        if (!ConfigProperties.DATABASE_MYSQL_HOST.isPresent()) {
            dbDeployer = (MySqlDeployer)((MySqlDeployer)((MySqlDeployer)new MySqlDeployer(ocp).withProject(ConfigProperties.OCP_PROJECT_MYSQL)).withDeployment(DB_DEPLOYMENT_PATH)).withServices(new String[]{DB_SERVICE_PATH_LB, DB_SERVICE_PATH});
            dbDeployer.deploy();
        }
        connectorName = "inventory-connector-mysql-" + testUtils.getUniqueId();
        ConnectorConfigBuilder connectorConfig = connectorFactories.mysql().put("database.server.name", (Object)connectorName);
        kafkaConnectController.deployConnector(connectorName, connectorConfig);
    }

    @AfterAll
    public static void tearDownDatabase() throws IOException {
        kafkaConnectController.undeployConnector(connectorName);
    }

    @Test
    @Order(value=1)
    public void shouldHaveRegisteredConnector() {
        Request r = new Request.Builder().url(kafkaConnectController.getApiURL().resolve("/connectors")).build();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            try (Response res = httpClient.newCall(r).execute();){
                Assertions.assertThat((String)res.body().string()).contains(new CharSequence[]{connectorName});
            }
        });
    }

    @Test
    @Order(value=2)
    public void shouldCreateKafkaTopics() {
        this.assertTopicsExist(connectorName + ".inventory.addresses", connectorName + ".inventory.customers", connectorName + ".inventory.geom", connectorName + ".inventory.orders", connectorName + ".inventory.products", connectorName + ".inventory.products_on_hand");
    }

    @Test
    @Order(value=3)
    public void shouldContainRecordsInCustomersTopic() throws IOException {
        kafkaConnectController.waitForMySqlSnapshot(connectorName);
        this.assertRecordsCount(connectorName + ".inventory.customers", 4);
    }

    static {
        httpClient = new OkHttpClient();
        connectorFactories = new ConnectorFactories();
    }
}

