/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.util.Testing;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Dependent
@Named(value="test")
public class TestConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    final List<Object> values = Collections.synchronizedList(new ArrayList());

    @PostConstruct
    void init() {
        Testing.print((Object)"Test consumer constructed");
    }

    @PreDestroy
    void close() {
        Testing.print((Object)"Test consumer destroyed");
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) {
        records.forEach(record -> {
            Testing.print((Object)record);
            this.values.add(record.value());
            try {
                committer.markProcessed(record);
            }
            catch (InterruptedException e) {
                throw new DebeziumException((Throwable)e);
            }
        });
    }

    public List<Object> getValues() {
        return this.values;
    }
}

