/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.data.Json;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class TestConfigSource
implements ConfigSource {
    public static final String OFFSETS_FILE = "file-connector-offsets.txt";
    public static final Path OFFSET_STORE_PATH = Testing.Files.createTestingPath((String)"file-connector-offsets.txt").toAbsolutePath();
    final Map<String, String> config = new HashMap<String, String>();

    public TestConfigSource() {
        this.config.put("debezium.sink.type", "test");
        this.config.put("debezium.source.connector.class", "io.debezium.connector.postgresql.PostgresConnector");
        this.config.put("debezium.source.offset.storage.file.filename", OFFSET_STORE_PATH.toAbsolutePath().toString());
        this.config.put("debezium.source.offset.flush.interval.ms", "0");
        this.config.put("debezium.source.topic.prefix", "testc");
        this.config.put("debezium.source.schema.include.list", "inventory");
        this.config.put("debezium.source.table.include.list", "inventory.customers");
        String format = System.getProperty("test.apicurio.converter.format");
        String formatKey = System.getProperty("debezium.format.key");
        String formatValue = System.getProperty("debezium.format.value");
        String formatHeader = System.getProperty("debezium.format.header", "json");
        if (format != null && format.length() != 0) {
            this.config.put("debezium.format.key", format);
            this.config.put("debezium.format.value", format);
            this.config.put("debezium.format.header", formatHeader);
            this.config.put("debezium.source.record.processing.threads", "1");
        } else {
            formatKey = formatKey != null ? formatKey : Json.class.getSimpleName().toLowerCase();
            formatValue = formatValue != null ? formatValue : Json.class.getSimpleName().toLowerCase();
            formatHeader = formatHeader != null ? formatHeader : Json.class.getSimpleName().toLowerCase();
            this.config.put("debezium.format.key", formatKey);
            this.config.put("debezium.format.value", formatValue);
            this.config.put("debezium.format.header", formatHeader);
        }
    }

    public Map<String, String> getProperties() {
        return this.config;
    }

    public String getValue(String propertyName) {
        return this.config.get(propertyName);
    }

    public String getName() {
        return "test";
    }

    public Set<String> getPropertyNames() {
        return this.config.keySet();
    }

    public static int waitForSeconds() {
        return 60;
    }
}

