/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.s3.history;

import com.adobe.testing.s3mock.testcontainers.S3MockContainer;
import io.debezium.config.Configuration;
import io.debezium.document.DocumentReader;
import io.debezium.relational.Tables;
import io.debezium.relational.history.AbstractSchemaHistoryTest;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.storage.s3.history.S3SchemaHistory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3SchemaHistoryIT
extends AbstractSchemaHistoryTest {
    public static final String IMAGE_TAG = System.getProperty("tag.smock", "latest");
    public static final String BUCKET = "debezium";
    public static final String OBJECT_NAME = String.format("db-history-%s.log", Thread.currentThread().getName());
    private static final S3MockContainer container = new S3MockContainer(IMAGE_TAG);
    private static S3Client client;

    @BeforeClass
    public static void startS3() {
        container.start();
        client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).region(Region.AWS_GLOBAL)).endpointOverride(URI.create(container.getHttpEndpoint()))).build();
    }

    @AfterClass
    public static void stopS3() {
        container.stop();
    }

    public void afterEach() {
        if (client.listBuckets().buckets().stream().map(Bucket::name).collect(Collectors.toList()).contains(BUCKET)) {
            client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(BUCKET).key(OBJECT_NAME).build());
            client.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(BUCKET).build());
        }
        super.afterEach();
    }

    protected SchemaHistory createHistory() {
        S3SchemaHistory history = new S3SchemaHistory();
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(S3SchemaHistory.ACCESS_KEY_ID, "aa")).with(S3SchemaHistory.SECRET_ACCESS_KEY, "bb")).with("schema.history.internal.s3.bucket.name", BUCKET).with(S3SchemaHistory.OBJECT_NAME, OBJECT_NAME)).with("schema.history.internal.s3.region.name", Region.AWS_GLOBAL.id()).with("schema.history.internal.s3.endpoint", container.getHttpEndpoint()).build();
        history.configure(config, null, SchemaHistoryListener.NOOP, true);
        history.start();
        return history;
    }

    @Test
    public void initializeStorageShouldCreateBucket() {
        try {
            client.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(BUCKET).build());
        }
        catch (NoSuchBucketException noSuchBucketException) {
            // empty catch block
        }
        this.history.initializeStorage();
        Assert.assertTrue((boolean)client.listBuckets().buckets().stream().map(Bucket::name).collect(Collectors.toList()).contains(BUCKET));
    }

    @Test
    public void shouldDetectExistingBucket() {
        try {
            client.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(BUCKET).build());
        }
        catch (NoSuchBucketException noSuchBucketException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.history.storageExists());
        this.history.initializeStorage();
        Assert.assertTrue((boolean)this.history.storageExists());
    }

    @Test
    public void storeRecordShouldSaveRecordsInS3() throws IOException {
        String line;
        this.record(1L, 0, "CREATE TABLE foo ( first VARCHAR(22) NOT NULL );", new Tables[]{this.all, this.t3, this.t2, this.t1, this.t0});
        List s3ObjectList = client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(BUCKET).build()).contents();
        Assert.assertEquals((long)1L, (long)s3ObjectList.size());
        S3Object s3Object = (S3Object)s3ObjectList.get(0);
        Assert.assertEquals((Object)OBJECT_NAME, (Object)s3Object.key());
        InputStream objectInputStream = (InputStream)client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(BUCKET).key(OBJECT_NAME).responseCacheControl(ContentType.TEXT_PLAIN.getMimeType()).build(), ResponseTransformer.toInputStream());
        BufferedReader historyReader = new BufferedReader(new InputStreamReader(objectInputStream, StandardCharsets.UTF_8));
        DocumentReader reader = DocumentReader.defaultReader();
        ArrayList<HistoryRecord> historyRecords = new ArrayList<HistoryRecord>();
        while ((line = historyReader.readLine()) != null) {
            historyRecords.add(new HistoryRecord(reader.read(historyReader.readLine())));
        }
        Assert.assertEquals((long)1L, (long)historyRecords.size());
        Assert.assertEquals((Object)"CREATE TABLE foo ( first VARCHAR(22) NOT NULL );", (Object)((HistoryRecord)historyRecords.get(0)).document().getString((CharSequence)"ddl"));
        Assert.assertEquals((long)1L, (long)((HistoryRecord)historyRecords.get(0)).document().getDocument((CharSequence)"position").getInteger((CharSequence)"position").intValue());
        Assert.assertEquals((long)0L, (long)((HistoryRecord)historyRecords.get(0)).document().getDocument((CharSequence)"position").getInteger((CharSequence)"entry").intValue());
    }
}

