/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.azure.blob.history;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import io.debezium.config.Configuration;
import io.debezium.document.DocumentReader;
import io.debezium.relational.Tables;
import io.debezium.relational.history.AbstractSchemaHistoryTest;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.storage.azure.blob.history.AzureBlobSchemaHistory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.containers.GenericContainer;

public class AzureBlobSchemaHistoryIT
extends AbstractSchemaHistoryTest {
    public static final String IMAGE_TAG = System.getProperty("tag.azurite", "latest");
    public static final String CONTAINER_NAME = "debezium";
    public static final String BLOB_NAME = "debezium-history.log";
    public static final String CONNECTION_STRING = "DefaultEndpointsProtocol=http;AccountName=account;AccountKey=key;BlobEndpoint=http://127.0.0.1:%s/account;";
    private static final GenericContainer<?> container = new GenericContainer(String.format("mcr.microsoft.com/azure-storage/azurite:%s", IMAGE_TAG)).withCommand("azurite --blobHost 0.0.0.0 --blobPort 10000").withEnv("AZURITE_ACCOUNTS", "account:key").withExposedPorts(new Integer[]{10000});
    private static BlobServiceClient blobServiceClient;

    @BeforeClass
    public static void startAzurite() {
        container.start();
        blobServiceClient = new BlobServiceClientBuilder().connectionString(String.format(CONNECTION_STRING, container.getMappedPort(10000))).buildClient();
    }

    @AfterClass
    public static void stopAzurite() {
        container.stop();
    }

    protected SchemaHistory createHistory() {
        AzureBlobSchemaHistory history = new AzureBlobSchemaHistory();
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(AzureBlobSchemaHistory.ACCOUNT_CONNECTION_STRING, String.format(CONNECTION_STRING, container.getMappedPort(10000)))).with(AzureBlobSchemaHistory.CONTAINER_NAME, CONTAINER_NAME)).with(AzureBlobSchemaHistory.BLOB_NAME, BLOB_NAME)).build();
        history.configure(config, null, SchemaHistoryListener.NOOP, true);
        history.start();
        return history;
    }

    @Test
    public void initializeStorageShouldCreateContainer() {
        blobServiceClient.deleteBlobContainer(CONTAINER_NAME);
        Assert.assertFalse((boolean)blobServiceClient.getBlobContainerClient(CONTAINER_NAME).exists());
        this.history.initializeStorage();
        Assert.assertTrue((boolean)blobServiceClient.getBlobContainerClient(CONTAINER_NAME).exists());
    }

    @Test
    public void storeRecordShouldSaveRecordsInBlobStorage() throws IOException {
        String line;
        BlobClient blobClient = blobServiceClient.getBlobContainerClient(CONTAINER_NAME).getBlobClient(BLOB_NAME);
        Assert.assertFalse((boolean)blobClient.exists());
        this.record(1L, 0, "CREATE TABLE foo ( first VARCHAR(22) NOT NULL );", new Tables[]{this.all, this.t3, this.t2, this.t1, this.t0});
        Assert.assertTrue((boolean)blobClient.exists());
        ArrayList<HistoryRecord> historyRecords = new ArrayList<HistoryRecord>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(blobClient.downloadContent().toBytes());
        BufferedReader historyReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        DocumentReader reader = DocumentReader.defaultReader();
        while ((line = historyReader.readLine()) != null) {
            historyRecords.add(new HistoryRecord(reader.read(historyReader.readLine())));
        }
        Assert.assertEquals((long)1L, (long)historyRecords.size());
        Assert.assertEquals((Object)"CREATE TABLE foo ( first VARCHAR(22) NOT NULL );", (Object)((HistoryRecord)historyRecords.get(0)).document().getString((CharSequence)"ddl"));
        Assert.assertEquals((long)1L, (long)((HistoryRecord)historyRecords.get(0)).document().getDocument((CharSequence)"position").getInteger((CharSequence)"position").intValue());
        Assert.assertEquals((long)0L, (long)((HistoryRecord)historyRecords.get(0)).document().getDocument((CharSequence)"position").getInteger((CharSequence)"entry").intValue());
    }
}

