/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Field;
import io.debezium.transforms.AbstractExtractNewRecordState;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.util.BoundedConcurrentHashMap;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.ReplaceField;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewRecordState<R extends ConnectRecord<R>>
extends AbstractExtractNewRecordState<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewRecordState.class);
    private static final String EXCLUDE = "exclude";
    private static final int SCHEMA_CACHE_SIZE = 64;
    private static final Field DROP_FIELDS_HEADER = Field.create("drop.fields.header.name").withDisplayName("Specifies a header that contains a list of field names to be removed").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Specifies the name of a header that contains a list of fields to be removed from the event value.");
    private static final Field DROP_FIELDS_FROM_KEY = Field.create("drop.fields.from.key").withDisplayName("Specifies whether the fields to be dropped should also be omitted from the key").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Specifies whether to apply the drop fields behavior to the event key as well as the value. Default behavior is to only remove fields from the event value, not the key.");
    private static final Field DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE = Field.create("drop.fields.keep.schema.compatible").withDisplayName("Specifies if fields are dropped, will the event's schemas be compatible").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withDescription("Controls the output event's schema compatibility when using the drop fields feature. `true`: dropped fields are removed if the schema indicates its optional leaving the schemas unchanged, `false`: dropped fields are removed from the key/value schemas, regardless of optionality.");
    private String dropFieldsHeaderName;
    private boolean dropFieldsFromKey;
    private boolean dropFieldsKeepSchemaCompatible;
    private BoundedConcurrentHashMap<AbstractExtractNewRecordState.NewRecordValueMetadata, Schema> schemaUpdateCache;
    private final Field.Set configFields = ExtractNewRecordStateConfigDefinition.CONFIG_FIELDS.with(DROP_FIELDS_HEADER, DROP_FIELDS_FROM_KEY, DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE);

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.dropFieldsHeaderName = this.config.getString(DROP_FIELDS_HEADER);
        this.dropFieldsFromKey = this.config.getBoolean(DROP_FIELDS_FROM_KEY);
        this.dropFieldsKeepSchemaCompatible = this.config.getBoolean(DROP_FIELDS_KEEP_SCHEMA_COMPATIBLE);
        this.schemaUpdateCache = new BoundedConcurrentHashMap(64);
    }

    @Override
    public R doApply(R record) {
        boolean isTombstone = record.value() == null;
        boolean isValidEnvelope = this.smtManager.isValidEnvelope(record);
        if ((isValidEnvelope || isTombstone) && !this.additionalHeaders.isEmpty()) {
            Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)record.value());
            headersToAdd.forEach(h -> record.headers().add(h));
        }
        if (isTombstone) {
            return this.extractRecordStrategy.handleTombstoneRecord(record);
        }
        if (!isValidEnvelope) {
            return record;
        }
        Object newRecord = this.extractRecordStrategy.afterDelegate().apply(record);
        if (newRecord.value() == null && this.extractRecordStrategy.beforeDelegate().apply(record).value() == null) {
            return this.extractRecordStrategy.handleTruncateRecord(record);
        }
        if (newRecord.value() == null) {
            newRecord = this.extractRecordStrategy.handleDeleteRecord(record);
            if (newRecord == null) {
                return null;
            }
            if (this.routeByField != null) {
                Struct recordValue = Requirements.requireStruct((Object)record.value(), (String)"Read record to set topic routing for DELETE");
                String newTopicName = recordValue.getStruct("before").getString(this.routeByField);
                newRecord = this.setTopic(newTopicName, newRecord);
            }
            if (!Strings.isNullOrBlank(this.dropFieldsHeaderName)) {
                newRecord = this.dropFields(newRecord);
            }
            if (newRecord.value() != null) {
                newRecord = this.addFields(this.additionalFields, record, newRecord);
            }
        } else {
            newRecord = this.extractRecordStrategy.handleRecord(record);
            if (this.routeByField != null) {
                Struct recordValue = Requirements.requireStruct((Object)newRecord.value(), (String)"Read record to set topic routing for CREATE / UPDATE");
                String newTopicName = recordValue.getString(this.routeByField);
                newRecord = this.setTopic(newTopicName, newRecord);
            }
            newRecord = this.addFields(this.additionalFields, record, newRecord);
            if (!Strings.isNullOrEmpty(this.dropFieldsHeaderName)) {
                newRecord = this.dropFields(newRecord);
            }
        }
        return (R)newRecord;
    }

    @Override
    public Iterable<Field> validateConfigFields() {
        return this.configFields;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, this.configFields.asArray());
        return config;
    }

    private R addFields(List<AbstractExtractNewRecordState.FieldReference> additionalFields, R originalRecord, R unwrappedRecord) {
        Struct value = Requirements.requireStruct((Object)unwrappedRecord.value(), (String)"source field insertion");
        Struct originalRecordValue = (Struct)originalRecord.value();
        Schema updatedSchema = this.schemaUpdateCache.computeIfAbsent(this.buildCacheKey(value, originalRecord), s -> this.makeUpdatedSchema(additionalFields, value.schema(), originalRecordValue));
        Struct updatedValue = new Struct(updatedSchema);
        for (org.apache.kafka.connect.data.Field field : value.schema().fields()) {
            updatedValue.put(field.name(), value.getWithoutDefault(field.name()));
        }
        for (AbstractExtractNewRecordState.FieldReference fieldReference : additionalFields) {
            Optional<Schema> schema = fieldReference.getSchema(originalRecordValue.schema());
            if (!schema.isPresent()) continue;
            updatedValue = this.updateValue(fieldReference, updatedValue, originalRecordValue);
        }
        return (R)unwrappedRecord.newRecord(unwrappedRecord.topic(), unwrappedRecord.kafkaPartition(), unwrappedRecord.keySchema(), unwrappedRecord.key(), updatedSchema, (Object)updatedValue, unwrappedRecord.timestamp());
    }

    private AbstractExtractNewRecordState.NewRecordValueMetadata buildCacheKey(Struct value, R originalRecord) {
        return new AbstractExtractNewRecordState.NewRecordValueMetadata(value.schema(), ((Struct)originalRecord.value()).getString("op"));
    }

    private R dropFields(R record) {
        if (Strings.isNullOrBlank(this.dropFieldsHeaderName)) {
            return record;
        }
        Header dropFieldsHeader = this.getHeaderByName(record, this.dropFieldsHeaderName);
        if (dropFieldsHeader == null || dropFieldsHeader.value() == null) {
            return record;
        }
        List fieldNames = (List)dropFieldsHeader.value();
        if (fieldNames.isEmpty()) {
            return record;
        }
        return this.dropValueFields(this.dropKeyFields(record, fieldNames), fieldNames);
    }

    private R dropKeyFields(R record, List<String> fieldNames) {
        List<String> keyFieldsToDrop;
        if (this.dropFieldsFromKey && record.key() != null && !(keyFieldsToDrop = this.getFieldsToDropFromSchema(record.keySchema(), fieldNames)).isEmpty()) {
            try (ReplaceField.Key delegate = new ReplaceField.Key();){
                delegate.configure(Map.of(EXCLUDE, Strings.join((CharSequence)",", keyFieldsToDrop)));
                record = delegate.apply(record);
            }
        }
        return record;
    }

    private R dropValueFields(R record, List<String> fieldNames) {
        List<String> valueFieldsToDrop = this.getFieldsToDropFromSchema(record.valueSchema(), fieldNames);
        if (!valueFieldsToDrop.isEmpty()) {
            try (ReplaceField.Value delegate = new ReplaceField.Value();){
                delegate.configure(Map.of(EXCLUDE, Strings.join((CharSequence)",", valueFieldsToDrop)));
                record = delegate.apply(record);
            }
        }
        return record;
    }

    private List<String> getFieldsToDropFromSchema(Schema schema, List<String> fieldNames) {
        if (!this.dropFieldsKeepSchemaCompatible) {
            return fieldNames;
        }
        ArrayList<String> fieldsToDrop = new ArrayList<String>();
        for (org.apache.kafka.connect.data.Field field : schema.fields()) {
            if (!field.schema().isOptional() || !fieldNames.contains(field.name())) continue;
            fieldsToDrop.add(field.name());
        }
        return fieldsToDrop;
    }

    private Schema makeUpdatedSchema(List<AbstractExtractNewRecordState.FieldReference> additionalFields, Schema schema, Struct originalRecordValue) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)schema, (SchemaBuilder)SchemaBuilder.struct());
        for (org.apache.kafka.connect.data.Field field : schema.fields()) {
            builder.field(field.name(), field.schema());
        }
        for (AbstractExtractNewRecordState.FieldReference fieldReference : additionalFields) {
            Optional<Schema> fieldSchema = fieldReference.getSchema(originalRecordValue.schema());
            if (!fieldSchema.isPresent()) continue;
            builder = this.updateSchema(fieldReference, builder, fieldSchema.get());
        }
        return builder.build();
    }

    private SchemaBuilder updateSchema(AbstractExtractNewRecordState.FieldReference fieldReference, SchemaBuilder builder, Schema fieldSchema) {
        return builder.field(fieldReference.getNewField(), fieldSchema);
    }

    private Struct updateValue(AbstractExtractNewRecordState.FieldReference fieldReference, Struct updatedValue, Struct struct) {
        return updatedValue.put(fieldReference.getNewField(), fieldReference.getValue(struct));
    }
}

