/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.acl;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.body.ClusterAclVersionInfo;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class ClusterAclConfigVersionListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "clusterAclConfigVersion";
    }

    @Override
    public String commandDesc() {
        return "List all of acl config version information in cluster.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = new Option("b", "brokerAddr", true, "query acl config version for which broker");
        optionGroup.addOption(opt);
        opt = new Option("c", "clusterName", true, "query acl config version for specified cluster");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            if (commandLine.hasOption('b')) {
                String addr = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                this.printClusterBaseInfo(defaultMQAdminExt, addr);
                System.out.printf("get broker's plain access config version success. Address:%s %n", addr);
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                System.out.printf("%-16s  %-22s  %-22s  %-20s  %-22s  %-22s%n", "#Cluster Name", "#Broker Name", "#Broker Addr", "#AclFilePath", "#AclConfigVersionNum", "#AclLastUpdateTime");
                for (String addr : masterSet) {
                    this.printClusterBaseInfo(defaultMQAdminExt, addr);
                }
                System.out.printf("get cluster's plain access config version success.%n", new Object[0]);
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private void printClusterBaseInfo(DefaultMQAdminExt defaultMQAdminExt, String addr) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ClusterAclVersionInfo clusterAclVersionInfo = defaultMQAdminExt.examineBrokerClusterAclVersionInfo(addr);
        Map aclDataVersion = clusterAclVersionInfo.getAllAclConfigDataVersion();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (aclDataVersion.size() > 0) {
            for (Map.Entry entry : aclDataVersion.entrySet()) {
                System.out.printf("%-16s  %-22s  %-22s  %-20s  %-22s  %-22s%n", clusterAclVersionInfo.getClusterName(), clusterAclVersionInfo.getBrokerName(), clusterAclVersionInfo.getBrokerAddr(), entry.getKey(), String.valueOf(((DataVersion)entry.getValue()).getCounter()), sdf.format(new Timestamp(((DataVersion)entry.getValue()).getTimestamp())));
            }
        }
    }
}

