/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.pipeline.signal.actions.snapshotting.AdditionalCondition;
import io.debezium.pipeline.source.snapshot.incremental.DataCollection;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.HexConverter;
import io.debezium.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AbstractIncrementalSnapshotContext<T>
implements IncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIncrementalSnapshotContext.class);
    public static final String INCREMENTAL_SNAPSHOT_KEY = "incremental_snapshot";
    public static final String EVENT_PRIMARY_KEY = "incremental_snapshot_primary_key";
    public static final String TABLE_MAXIMUM_KEY = "incremental_snapshot_maximum_key";
    public static final String CORRELATION_ID = "incremental_snapshot_correlation_id";
    private final SnapshotDataCollection<T> snapshotDataCollection = new SnapshotDataCollection();
    protected boolean windowOpened = false;
    private Object[] chunkEndPosition;
    private final boolean useCatalogBeforeSchema;
    private Object[] lastEventKeySent;
    private String currentChunkId;
    private Object[] maximumKey;
    private Table schema;
    private boolean schemaVerificationPassed;
    private String correlationId;
    private final AtomicBoolean paused = new AtomicBoolean(false);
    private final LinkedBlockingQueue<String> dataCollectionsToStop = new LinkedBlockingQueue();

    public AbstractIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
    }

    @Override
    public boolean openWindow(String id) {
        if (this.notExpectedChunk(id)) {
            LOGGER.info("Received request to open window with id = '{}', expected = '{}', request ignored", (Object)id, (Object)this.currentChunkId);
            return false;
        }
        LOGGER.debug("Opening window for incremental snapshot chunk");
        this.windowOpened = true;
        return true;
    }

    @Override
    public boolean closeWindow(String id) {
        if (this.notExpectedChunk(id)) {
            LOGGER.info("Received request to close window with id = '{}', expected = '{}', request ignored", (Object)id, (Object)this.currentChunkId);
            return false;
        }
        LOGGER.debug("Closing window for incremental snapshot chunk");
        this.windowOpened = false;
        return true;
    }

    @Override
    public void pauseSnapshot() {
        LOGGER.info("Pausing incremental snapshot");
        this.paused.set(true);
    }

    @Override
    public void resumeSnapshot() {
        LOGGER.info("Resuming incremental snapshot");
        this.paused.set(false);
    }

    @Override
    public boolean isSnapshotPaused() {
        return this.paused.get();
    }

    private boolean notExpectedChunk(String id) {
        return this.currentChunkId == null || !id.startsWith(this.currentChunkId);
    }

    @Override
    public boolean deduplicationNeeded() {
        return this.windowOpened;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String arrayToSerializedString(Object[] array) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(array);
                string = HexConverter.convertToHexString(bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DebeziumException(String.format("Cannot serialize chunk information %s", array));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object[] serializedStringToArray(String field, String serialized) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(HexConverter.convertFromHex(serialized));){
            Object[] objectArray;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                objectArray = (Object[])ois.readObject();
            }
            return objectArray;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Failed to deserialize '%s' with value '%s'", field, serialized), (Throwable)e);
        }
    }

    @Override
    public List<String> getDataCollectionsToStop() {
        ArrayList<String> drainedList = new ArrayList<String>();
        this.dataCollectionsToStop.drainTo(drainedList);
        return drainedList;
    }

    @Override
    public boolean snapshotRunning() {
        return !this.snapshotDataCollection.isEmpty();
    }

    @Override
    public Map<String, Object> store(Map<String, Object> offset) {
        if (!this.snapshotRunning()) {
            return offset;
        }
        offset.put(EVENT_PRIMARY_KEY, this.arrayToSerializedString(this.lastEventKeySent));
        offset.put(TABLE_MAXIMUM_KEY, this.arrayToSerializedString(this.maximumKey));
        offset.put("incremental_snapshot_collections", this.snapshotDataCollection.dataCollectionsAsJsonString());
        offset.put(CORRELATION_ID, this.correlationId);
        return offset;
    }

    private void addTablesIdsToSnapshot(List<DataCollection<T>> dataCollectionIds) {
        this.snapshotDataCollection.add(dataCollectionIds);
    }

    @Override
    public List<DataCollection<T>> addDataCollectionNamesToSnapshot(String correlationId, List<String> dataCollectionIds, List<AdditionalCondition> additionalCondition, String surrogateKey) {
        LOGGER.trace("Adding data collections names {} to snapshot", dataCollectionIds);
        List<DataCollection<T>> newDataCollectionIds = dataCollectionIds.stream().map(this.buildDataCollection(additionalCondition, surrogateKey)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.addTablesIdsToSnapshot(newDataCollectionIds);
        this.correlationId = correlationId;
        return newDataCollectionIds;
    }

    private Function<String, Optional<DataCollection<T>>> buildDataCollection(List<AdditionalCondition> additionalCondition, String surrogateKey) {
        return expandedCollectionName -> {
            String filter = additionalCondition.stream().filter(condition -> condition.getDataCollection().matcher((CharSequence)expandedCollectionName).matches()).map(AdditionalCondition::getFilter).findFirst().orElse("");
            try {
                TableId parsedTable = TableId.parse(expandedCollectionName, this.useCatalogBeforeSchema);
                return Optional.of(new DataCollection<TableId>(parsedTable, filter, surrogateKey));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to parse table identifier from {}. Skipping it.", expandedCollectionName);
                return Optional.empty();
            }
        };
    }

    @Override
    public void requestSnapshotStop(List<String> dataCollectionIds) {
        if (this.snapshotRunning()) {
            if (dataCollectionIds == null || dataCollectionIds.isEmpty()) {
                this.dataCollectionsToStop.add(".*");
            } else {
                this.dataCollectionsToStop.addAll(dataCollectionIds);
            }
        }
    }

    @Override
    public boolean removeDataCollectionFromSnapshot(String dataCollectionId) {
        TableId collectionId = TableId.parse(dataCollectionId, this.useCatalogBeforeSchema);
        return this.snapshotDataCollection.remove(List.of(new DataCollection<TableId>(collectionId)));
    }

    @Override
    public List<DataCollection<T>> getDataCollections() {
        return new ArrayList<DataCollection<T>>(this.snapshotDataCollection.getDataCollectionsToSnapshot());
    }

    @Override
    public void unsetCorrelationId() {
        this.correlationId = null;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    protected static <U> IncrementalSnapshotContext<U> init(AbstractIncrementalSnapshotContext<U> context, Map<String, ?> offsets) {
        String lastEventSentKeyStr = (String)offsets.get(EVENT_PRIMARY_KEY);
        context.chunkEndPosition = lastEventSentKeyStr != null ? context.serializedStringToArray(EVENT_PRIMARY_KEY, lastEventSentKeyStr) : null;
        context.lastEventKeySent = null;
        String maximumKeyStr = (String)offsets.get(TABLE_MAXIMUM_KEY);
        context.maximumKey = maximumKeyStr != null ? context.serializedStringToArray(TABLE_MAXIMUM_KEY, maximumKeyStr) : null;
        String dataCollectionsStr = (String)offsets.get("incremental_snapshot_collections");
        context.snapshotDataCollection.clear();
        if (dataCollectionsStr != null) {
            context.addTablesIdsToSnapshot(context.snapshotDataCollection.stringToDataCollections(dataCollectionsStr, context.useCatalogBeforeSchema));
        }
        context.correlationId = (String)offsets.get(CORRELATION_ID);
        return context;
    }

    @Override
    public void sendEvent(Object[] key) {
        this.lastEventKeySent = key;
    }

    @Override
    public DataCollection<T> currentDataCollectionId() {
        return this.snapshotDataCollection.peek();
    }

    @Override
    public int dataCollectionsToBeSnapshottedCount() {
        return this.snapshotDataCollection.size();
    }

    @Override
    public void nextChunkPosition(Object[] end) {
        this.chunkEndPosition = end;
    }

    @Override
    public Object[] chunkEndPosititon() {
        return this.chunkEndPosition;
    }

    private void resetChunk() {
        this.lastEventKeySent = null;
        this.chunkEndPosition = null;
        this.maximumKey = null;
        this.schema = null;
        this.schemaVerificationPassed = false;
    }

    @Override
    public void revertChunk() {
        this.chunkEndPosition = this.lastEventKeySent;
        this.windowOpened = false;
    }

    @Override
    public boolean isNonInitialChunk() {
        return this.chunkEndPosition != null;
    }

    @Override
    public DataCollection<T> nextDataCollection() {
        this.resetChunk();
        return this.snapshotDataCollection.getNext();
    }

    @Override
    public void startNewChunk() {
        this.currentChunkId = UUID.randomUUID().toString();
        LOGGER.debug("Starting new chunk with id '{}'", (Object)this.currentChunkId);
    }

    @Override
    public String currentChunkId() {
        return this.currentChunkId;
    }

    @Override
    public void maximumKey(Object[] key) {
        this.maximumKey = key;
    }

    @Override
    public Optional<Object[]> maximumKey() {
        return Optional.ofNullable(this.maximumKey);
    }

    @Override
    public Table getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Table schema) {
        this.schema = schema;
    }

    @Override
    public boolean isSchemaVerificationPassed() {
        return this.schemaVerificationPassed;
    }

    @Override
    public void setSchemaVerificationPassed(boolean schemaVerificationPassed) {
        this.schemaVerificationPassed = schemaVerificationPassed;
        LOGGER.info("Incremental snapshot's schema verification passed = {}, schema = {}", (Object)schemaVerificationPassed, (Object)this.schema);
    }

    public String toString() {
        return "IncrementalSnapshotContext [windowOpened=" + this.windowOpened + ", chunkEndPosition=" + Arrays.toString(this.chunkEndPosition) + ", dataCollectionsToSnapshot=" + String.valueOf(this.snapshotDataCollection.getDataCollectionsToSnapshot()) + ", lastEventKeySent=" + Arrays.toString(this.lastEventKeySent) + ", maximumKey=" + Arrays.toString(this.maximumKey) + "]";
    }

    private static class SnapshotDataCollection<T>
    extends LinkedBlockingQueue<DataCollection<T>> {
        public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY = "incremental_snapshot_collections";
        public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ID = "incremental_snapshot_collections_id";
        public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ADDITIONAL_CONDITION = "incremental_snapshot_collections_additional_condition";
        public static final String DATA_COLLECTIONS_TO_SNAPSHOT_KEY_SURROGATE_KEY = "incremental_snapshot_collections_surrogate_key";
        private final ObjectMapper mapper = new ObjectMapper();
        private final TypeReference<List<LinkedHashMap<String, String>>> mapperTypeRef = new TypeReference<List<LinkedHashMap<String, String>>>(){};
        private final Queue<DataCollection<T>> dataCollectionsToSnapshot = new LinkedList<DataCollection<T>>();
        private String dataCollectionsToSnapshotJson;

        SnapshotDataCollection() {
        }

        void add(List<DataCollection<T>> dataCollectionIds) {
            this.dataCollectionsToSnapshot.addAll(dataCollectionIds);
            this.dataCollectionsToSnapshotJson = this.computeJsonString();
        }

        DataCollection<T> getNext() {
            DataCollection<T> nextDataCollection = this.dataCollectionsToSnapshot.poll();
            this.dataCollectionsToSnapshotJson = this.computeJsonString();
            return nextDataCollection;
        }

        @Override
        public DataCollection<T> peek() {
            return this.dataCollectionsToSnapshot.peek();
        }

        @Override
        public int size() {
            return this.dataCollectionsToSnapshot.size();
        }

        @Override
        public void clear() {
            this.dataCollectionsToSnapshot.clear();
            this.dataCollectionsToSnapshotJson = null;
        }

        @Override
        public boolean isEmpty() {
            return this.dataCollectionsToSnapshot.isEmpty();
        }

        public boolean remove(List<DataCollection<T>> toRemove) {
            boolean removed = this.dataCollectionsToSnapshot.removeAll(toRemove);
            this.dataCollectionsToSnapshotJson = this.computeJsonString();
            return removed;
        }

        public String dataCollectionsAsJsonString() {
            if (!Strings.isNullOrEmpty(this.dataCollectionsToSnapshotJson)) {
                return this.dataCollectionsToSnapshotJson;
            }
            return this.computeJsonString();
        }

        public Queue<DataCollection<T>> getDataCollectionsToSnapshot() {
            return this.dataCollectionsToSnapshot;
        }

        private String computeJsonString() {
            try {
                List dataCollectionsMap = this.dataCollectionsToSnapshot.stream().map(x -> {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ID, x.getId().toString());
                    map.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ADDITIONAL_CONDITION, x.getAdditionalCondition().orElse(null));
                    map.put(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_SURROGATE_KEY, x.getSurrogateKey().orElse(null));
                    return map;
                }).collect(Collectors.toList());
                return this.mapper.writeValueAsString(dataCollectionsMap);
            }
            catch (JsonProcessingException e) {
                throw new DebeziumException("Cannot serialize dataCollectionsToSnapshot information");
            }
        }

        private List<DataCollection<T>> stringToDataCollections(String dataCollectionsStr, boolean useCatalogBeforeSchema) {
            try {
                List dataCollections = (List)this.mapper.readValue(dataCollectionsStr, this.mapperTypeRef);
                return dataCollections.stream().map(x -> new DataCollection<TableId>(TableId.parse((String)x.get(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ID), useCatalogBeforeSchema), Optional.ofNullable((String)x.get(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_ADDITIONAL_CONDITION)).orElse(""), Optional.ofNullable((String)x.get(DATA_COLLECTIONS_TO_SNAPSHOT_KEY_SURROGATE_KEY)).orElse(""))).collect(Collectors.toList());
            }
            catch (JsonProcessingException e) {
                throw new DebeziumException("Cannot de-serialize dataCollectionsToSnapshot information");
            }
        }
    }
}

