/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SnapshotType;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Optional;
import org.apache.kafka.connect.data.Struct;

public abstract class CommonOffsetContext<T extends BaseSourceInfo>
implements OffsetContext {
    public static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    protected final T sourceInfo;
    protected SnapshotType snapshot;
    protected boolean snapshotCompleted;

    public CommonOffsetContext(T sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public CommonOffsetContext(T sourceInfo, boolean snapshotCompleted) {
        this.sourceInfo = sourceInfo;
        this.snapshotCompleted = snapshotCompleted;
    }

    @Override
    public Struct getSourceInfo() {
        return ((AbstractSourceInfo)this.sourceInfo).struct();
    }

    @Override
    public void markSnapshotRecord(SnapshotRecord record) {
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(record);
    }

    @Override
    public boolean isInitialSnapshotRunning() {
        return this.getSnapshot().isPresent() && this.getSnapshot().get().equals((Object)SnapshotType.INITIAL) && !this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart(boolean onDemand) {
        this.snapshot = onDemand ? SnapshotType.BLOCKING : SnapshotType.INITIAL;
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.FALSE);
        this.snapshot = null;
    }

    @Override
    public void incrementalSnapshotEvents() {
        ((BaseSourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.INCREMENTAL);
        this.snapshot = SnapshotType.INCREMENTAL;
    }

    public Optional<SnapshotType> getSnapshot() {
        return Optional.ofNullable(this.snapshot);
    }

    public void setSnapshot(SnapshotType snapshotType) {
        this.snapshot = snapshotType;
    }
}

