/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.logging;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.rocketmq.common.logging.JoranConfiguratorExt;
import org.apache.rocketmq.logging.ch.qos.logback.classic.LoggerContext;
import org.apache.rocketmq.logging.ch.qos.logback.classic.spi.Configurator;
import org.apache.rocketmq.logging.ch.qos.logback.classic.util.DefaultJoranConfigurator;
import org.apache.rocketmq.logging.ch.qos.logback.core.LogbackException;
import org.apache.rocketmq.logging.ch.qos.logback.core.joran.spi.JoranException;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.InfoStatus;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.Status;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.StatusManager;
import org.apache.rocketmq.logging.ch.qos.logback.core.util.Loader;
import org.apache.rocketmq.logging.ch.qos.logback.core.util.OptionHelper;

public class DefaultJoranConfiguratorExt
extends DefaultJoranConfigurator {
    public static final String TEST_AUTOCONFIG_FILE = "rmq.logback-test.xml";
    public static final String AUTOCONFIG_FILE = "rmq.logback.xml";
    public static final String PROXY_AUTOCONFIG_FILE = "rmq.proxy.logback.xml";
    public static final String BROKER_AUTOCONFIG_FILE = "rmq.broker.logback.xml";
    public static final String NAMESRV_AUTOCONFIG_FILE = "rmq.namesrv.logback.xml";
    public static final String CONTROLLER_AUTOCONFIG_FILE = "rmq.controller.logback.xml";
    public static final String TOOLS_AUTOCONFIG_FILE = "rmq.tools.logback.xml";
    public static final String CLIENT_AUTOCONFIG_FILE = "rmq.client.logback.xml";
    private final List<String> configFiles = new ArrayList<String>();

    public DefaultJoranConfiguratorExt() {
        this.configFiles.add(TEST_AUTOCONFIG_FILE);
        this.configFiles.add(AUTOCONFIG_FILE);
        this.configFiles.add(PROXY_AUTOCONFIG_FILE);
        this.configFiles.add(BROKER_AUTOCONFIG_FILE);
        this.configFiles.add(NAMESRV_AUTOCONFIG_FILE);
        this.configFiles.add(CONTROLLER_AUTOCONFIG_FILE);
        this.configFiles.add(TOOLS_AUTOCONFIG_FILE);
        this.configFiles.add(CLIENT_AUTOCONFIG_FILE);
    }

    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        URL url = this.findURLOfDefaultConfigurationFile(true);
        if (url != null) {
            try {
                this.configureByResource(url);
            }
            catch (JoranException e) {
                e.printStackTrace();
            }
        }
        return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
    }

    public void configureByResource(URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String urlString = url.toString();
        if (!urlString.endsWith("xml")) {
            throw new LogbackException("Unexpected filename extension of file [" + url + "]. Should be .xml");
        }
        JoranConfiguratorExt configurator = new JoranConfiguratorExt();
        configurator.setContext(this.context);
        configurator.doConfigure0(url);
    }

    public URL findURLOfDefaultConfigurationFile(boolean updateStatus) {
        ClassLoader myClassLoader = Loader.getClassLoaderOfObject((Object)((Object)this));
        URL url = this.findConfigFileURLFromSystemProperties(myClassLoader, updateStatus);
        if (url != null) {
            return url;
        }
        for (String configFile : this.configFiles) {
            url = this.getResource(configFile, myClassLoader, updateStatus);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean updateStatus) {
        String logbackConfigFile = OptionHelper.getSystemProperty((String)"rmq.logback.configurationFile");
        if (logbackConfigFile != null) {
            URL result = null;
            try {
                URL uRL = result = new URL(logbackConfigFile);
                return uRL;
            }
            catch (MalformedURLException e) {
                result = Loader.getResource((String)logbackConfigFile, (ClassLoader)classLoader);
                if (result != null) {
                    URL uRL = result;
                    return uRL;
                }
                File f = new File(logbackConfigFile);
                if (f.exists() && f.isFile()) {
                    try {
                        URL uRL = result = f.toURI().toURL();
                        return uRL;
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            finally {
                if (updateStatus) {
                    this.statusOnResourceSearch(logbackConfigFile, classLoader, result);
                }
            }
        }
        return null;
    }

    private URL getResource(String filename, ClassLoader myClassLoader, boolean updateStatus) {
        URL url = Loader.getResource((String)filename, (ClassLoader)myClassLoader);
        if (updateStatus) {
            this.statusOnResourceSearch(filename, myClassLoader, url);
        }
        return url;
    }

    private void statusOnResourceSearch(String resourceName, ClassLoader classLoader, URL url) {
        StatusManager sm = this.context.getStatusManager();
        if (url == null) {
            sm.add((Status)new InfoStatus("Could NOT find resource [" + resourceName + "]", (Object)this.context));
        } else {
            sm.add((Status)new InfoStatus("Found resource [" + resourceName + "] at [" + url.toString() + "]", (Object)this.context));
            this.multiplicityWarning(resourceName, classLoader);
        }
    }

    private void multiplicityWarning(String resourceName, ClassLoader classLoader) {
        Set urlSet = null;
        try {
            urlSet = Loader.getResources((String)resourceName, (ClassLoader)classLoader);
        }
        catch (IOException e) {
            this.addError("Failed to get url list for resource [" + resourceName + "]", e);
        }
        if (urlSet != null && urlSet.size() > 1) {
            this.addWarn("Resource [" + resourceName + "] occurs multiple times on the classpath.");
            for (URL url : urlSet) {
                this.addWarn("Resource [" + resourceName + "] occurs at [" + url.toString() + "]");
            }
        }
    }
}

