/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header.controller;

import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;

public class ElectMasterRequestHeader
implements CommandCustomHeader {
    @CFNotNull
    private String clusterName;
    @CFNotNull
    private String brokerName;
    @CFNotNull
    private Long brokerId;
    @CFNotNull
    private Boolean designateElect = false;

    public ElectMasterRequestHeader() {
    }

    public ElectMasterRequestHeader(String brokerName) {
        this.brokerName = brokerName;
    }

    public ElectMasterRequestHeader(String clusterName, String brokerName, Long brokerId) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerId = brokerId;
    }

    public ElectMasterRequestHeader(String clusterName, String brokerName, Long brokerId, boolean designateElect) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerId = brokerId;
        this.designateElect = designateElect;
    }

    public static ElectMasterRequestHeader ofBrokerTrigger(String clusterName, String brokerName, Long brokerId) {
        return new ElectMasterRequestHeader(clusterName, brokerName, brokerId);
    }

    public static ElectMasterRequestHeader ofControllerTrigger(String brokerName) {
        return new ElectMasterRequestHeader(brokerName);
    }

    public static ElectMasterRequestHeader ofAdminTrigger(String clusterName, String brokerName, Long brokerId) {
        return new ElectMasterRequestHeader(clusterName, brokerName, brokerId, true);
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public Long getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(Long brokerId) {
        this.brokerId = brokerId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public boolean getDesignateElect() {
        return this.designateElect;
    }

    public String toString() {
        return "ElectMasterRequestHeader{clusterName='" + this.clusterName + '\'' + ", brokerName='" + this.brokerName + '\'' + ", brokerId=" + this.brokerId + ", designateElect=" + this.designateElect + '}';
    }

    @Override
    public void checkFields() throws RemotingCommandException {
    }
}

