/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(LoggingSpanExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public static LoggingSpanExporter create() {
        return new LoggingSpanExporter();
    }

    @Deprecated
    public LoggingSpanExporter() {
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        StringBuilder sb = new StringBuilder(60);
        for (SpanData span : spans) {
            sb.setLength(0);
            InstrumentationScopeInfo instrumentationScopeInfo = span.getInstrumentationScopeInfo();
            sb.append("'").append(span.getName()).append("' : ").append(span.getTraceId()).append(" ").append(span.getSpanId()).append(" ").append(span.getKind()).append(" [tracer: ").append(instrumentationScopeInfo.getName()).append(":").append(instrumentationScopeInfo.getVersion() == null ? "" : instrumentationScopeInfo.getVersion()).append("] ").append(span.getAttributes());
            logger.log(Level.INFO, sb.toString());
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        CompletableResultCode resultCode = new CompletableResultCode();
        for (Handler handler : logger.getHandlers()) {
            try {
                handler.flush();
            }
            catch (Throwable t) {
                resultCode.fail();
            }
        }
        return resultCode.succeed();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.flush();
    }
}

