/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;

public class GroupMetadataUpdateEvent
extends BackgroundEvent {
    private final int memberEpoch;
    private final String memberId;

    public GroupMetadataUpdateEvent(int memberEpoch, String memberId) {
        super(BackgroundEvent.Type.GROUP_METADATA_UPDATE);
        this.memberEpoch = memberEpoch;
        this.memberId = memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public String memberId() {
        return this.memberId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupMetadataUpdateEvent that = (GroupMetadataUpdateEvent)o;
        return this.memberEpoch == that.memberEpoch && Objects.equals(this.memberId, that.memberId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.memberEpoch, this.memberId);
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", memberEpoch=" + this.memberEpoch + ", memberId='" + this.memberId + '\'';
    }

    @Override
    public String toString() {
        return "GroupMetadataUpdateEvent{" + this.toStringBase() + '}';
    }
}

