/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.PluginInfo;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.runtime.rest.resources.ConnectResource;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.tools.MockSinkConnector;
import org.apache.kafka.connect.tools.MockSourceConnector;
import org.apache.kafka.connect.tools.SchemaSourceConnector;
import org.apache.kafka.connect.tools.VerifiableSinkConnector;
import org.apache.kafka.connect.tools.VerifiableSourceConnector;
import org.apache.kafka.connect.util.FutureCallback;

@Path(value="/connector-plugins")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorPluginsResource
implements ConnectResource {
    private static final String ALIAS_SUFFIX = "Connector";
    private final Herder herder;
    private final List<PluginInfo> connectorPlugins;
    private long requestTimeoutMs;
    static final List<Class<? extends SinkConnector>> SINK_CONNECTOR_EXCLUDES = Arrays.asList(VerifiableSinkConnector.class, MockSinkConnector.class);
    static final List<Class<? extends SourceConnector>> SOURCE_CONNECTOR_EXCLUDES = Arrays.asList(VerifiableSourceConnector.class, MockSourceConnector.class, SchemaSourceConnector.class);

    public ConnectorPluginsResource(Herder herder) {
        this.herder = herder;
        this.connectorPlugins = new ArrayList<PluginInfo>();
        this.requestTimeoutMs = DEFAULT_REST_REQUEST_TIMEOUT_MS;
        this.addConnectorPlugins(herder.plugins().sinkConnectors(), SINK_CONNECTOR_EXCLUDES);
        this.addConnectorPlugins(herder.plugins().sourceConnectors(), SOURCE_CONNECTOR_EXCLUDES);
        this.addConnectorPlugins(herder.plugins().transformations(), Collections.emptySet());
        this.addConnectorPlugins(herder.plugins().predicates(), Collections.emptySet());
        this.addConnectorPlugins(herder.plugins().converters(), Collections.emptySet());
        this.addConnectorPlugins(herder.plugins().headerConverters(), Collections.emptySet());
    }

    private <T> void addConnectorPlugins(Collection<PluginDesc<T>> plugins, Collection<Class<? extends T>> excludes) {
        plugins.stream().filter(p -> !excludes.contains(p.pluginClass())).map(PluginInfo::new).forEach(this.connectorPlugins::add);
    }

    @Override
    public void requestTimeout(long requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    @PUT
    @Path(value="/{pluginName}/config/validate")
    @Operation(summary="Validate the provided configuration against the configuration definition for the specified pluginName")
    public ConfigInfos validateConfigs(@PathParam(value="pluginName") String pluginName, Map<String, String> connectorConfig) throws Throwable {
        String includedConnType = connectorConfig.get("connector.class");
        if (includedConnType != null && !this.normalizedPluginName(includedConnType).endsWith(this.normalizedPluginName(pluginName))) {
            throw new BadRequestException("Included connector type " + includedConnType + " does not match request type " + pluginName);
        }
        FutureCallback<ConfigInfos> validationCallback = new FutureCallback<ConfigInfos>();
        this.herder.validateConnectorConfig(connectorConfig, validationCallback, false);
        try {
            return (ConfigInfos)validationCallback.get(this.requestTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request timed out");
        }
        catch (InterruptedException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/")
    @Operation(summary="List all connector plugins installed")
    public List<PluginInfo> listConnectorPlugins(@DefaultValue(value="true") @QueryParam(value="connectorsOnly") @Parameter(description="Whether to list only connectors instead of all plugins") boolean connectorsOnly) {
        ConnectorPluginsResource connectorPluginsResource = this;
        synchronized (connectorPluginsResource) {
            if (connectorsOnly) {
                return Collections.unmodifiableList(this.connectorPlugins.stream().filter(p -> PluginType.SINK.toString().equals(p.type()) || PluginType.SOURCE.toString().equals(p.type())).collect(Collectors.toList()));
            }
            return Collections.unmodifiableList(this.connectorPlugins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{pluginName}/config")
    @Operation(summary="Get the configuration definition for the specified pluginName")
    public List<ConfigKeyInfo> getConnectorConfigDef(@PathParam(value="pluginName") String pluginName) {
        ConnectorPluginsResource connectorPluginsResource = this;
        synchronized (connectorPluginsResource) {
            return this.herder.connectorPluginConfig(pluginName);
        }
    }

    private String normalizedPluginName(String pluginName) {
        return pluginName.endsWith(ALIAS_SUFFIX) && pluginName.length() > ALIAS_SUFFIX.length() ? pluginName.substring(0, pluginName.length() - ALIAS_SUFFIX.length()) : pluginName;
    }
}

