/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.cli.AbstractConnectCli;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.standalone.StandaloneConfig;
import org.apache.kafka.connect.runtime.standalone.StandaloneHerder;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.util.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectStandalone
extends AbstractConnectCli<StandaloneConfig> {
    private static final Logger log = LoggerFactory.getLogger(ConnectStandalone.class);

    protected ConnectStandalone(String ... args) {
        super(args);
    }

    @Override
    protected String usage() {
        return "ConnectStandalone worker.properties [connector1.properties connector2.properties ...]";
    }

    @Override
    protected void processExtraArgs(Herder herder, Connect connect, String[] extraArgs) {
        try {
            for (String connectorPropsFile : extraArgs) {
                Map connectorProps = Utils.propsToStringMap((Properties)Utils.loadProps((String)connectorPropsFile));
                FutureCallback<Herder.Created<ConnectorInfo>> cb = new FutureCallback<Herder.Created<ConnectorInfo>>((error, info) -> {
                    if (error != null) {
                        log.error("Failed to create connector for {}", (Object)connectorPropsFile);
                    } else {
                        log.info("Created connector {}", (Object)((ConnectorInfo)info.result()).name());
                    }
                });
                herder.putConnectorConfig((String)connectorProps.get("name"), connectorProps, false, cb);
                cb.get();
            }
        }
        catch (Throwable t) {
            log.error("Stopping after connector error", t);
            connect.stop();
            Exit.exit((int)3);
        }
    }

    @Override
    protected Herder createHerder(StandaloneConfig config, String workerId, Plugins plugins, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, RestServer restServer, RestClient restClient) {
        FileOffsetBackingStore offsetBackingStore = new FileOffsetBackingStore(plugins.newInternalConverter(true, JsonConverter.class.getName(), Collections.singletonMap("schemas.enable", "false")));
        offsetBackingStore.configure(config);
        Worker worker = new Worker(workerId, Time.SYSTEM, plugins, config, offsetBackingStore, connectorClientConfigOverridePolicy);
        return new StandaloneHerder(worker, config.kafkaClusterId(), connectorClientConfigOverridePolicy);
    }

    @Override
    protected StandaloneConfig createConfig(Map<String, String> workerProps) {
        return new StandaloneConfig(workerProps);
    }

    public static void main(String[] args) {
        ConnectStandalone connectStandalone = new ConnectStandalone(args);
        connectStandalone.run();
    }
}

