/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigRequest;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.health.ConnectorType;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.CloseableConnectorContext;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.ExactlyOnceWorkerSourceTask;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.SinkConnectorConfig;
import org.apache.kafka.connect.runtime.SourceConnectorConfig;
import org.apache.kafka.connect.runtime.SourceTaskOffsetCommitter;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskConfig;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.TransformationChain;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import org.apache.kafka.connect.runtime.WorkerConnector;
import org.apache.kafka.connect.runtime.WorkerMetricsGroup;
import org.apache.kafka.connect.runtime.WorkerSinkTask;
import org.apache.kafka.connect.runtime.WorkerSourceTask;
import org.apache.kafka.connect.runtime.WorkerTask;
import org.apache.kafka.connect.runtime.errors.DeadLetterQueueReporter;
import org.apache.kafka.connect.runtime.errors.ErrorHandlingMetrics;
import org.apache.kafka.connect.runtime.errors.ErrorReporter;
import org.apache.kafka.connect.runtime.errors.LogReporter;
import org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.kafka.connect.runtime.errors.WorkerErrantRecordReporter;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.apache.kafka.connect.storage.CloseableOffsetStorageReader;
import org.apache.kafka.connect.storage.ClusterConfigState;
import org.apache.kafka.connect.storage.ConnectorOffsetBackingStore;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetStorageReaderImpl;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.LoggingContext;
import org.apache.kafka.connect.util.SinkUtils;
import org.apache.kafka.connect.util.TopicAdmin;
import org.apache.kafka.connect.util.TopicCreationGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker {
    public static final long CONNECTOR_GRACEFUL_SHUTDOWN_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(5L);
    public static final long EXECUTOR_SHUTDOWN_TERMINATION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final Logger log = LoggerFactory.getLogger(Worker.class);
    protected Herder herder;
    private final ExecutorService executor;
    private final Time time;
    private final String workerId;
    private final String kafkaClusterId;
    private final Plugins plugins;
    private final ConnectMetrics metrics;
    private final WorkerMetricsGroup workerMetricsGroup;
    private ConnectorStatusMetricsGroup connectorStatusMetricsGroup;
    private final WorkerConfig config;
    private final Converter internalKeyConverter;
    private final Converter internalValueConverter;
    private final OffsetBackingStore globalOffsetBackingStore;
    private final ConcurrentMap<String, WorkerConnector> connectors = new ConcurrentHashMap<String, WorkerConnector>();
    private final ConcurrentMap<ConnectorTaskId, WorkerTask> tasks = new ConcurrentHashMap<ConnectorTaskId, WorkerTask>();
    private Optional<SourceTaskOffsetCommitter> sourceTaskOffsetCommitter;
    private final WorkerConfigTransformer workerConfigTransformer;
    private final ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy;

    public Worker(String workerId, Time time, Plugins plugins, WorkerConfig config, OffsetBackingStore globalOffsetBackingStore, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        this(workerId, time, plugins, config, globalOffsetBackingStore, Executors.newCachedThreadPool(), connectorClientConfigOverridePolicy);
    }

    Worker(String workerId, Time time, Plugins plugins, WorkerConfig config, OffsetBackingStore globalOffsetBackingStore, ExecutorService executorService, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        this.kafkaClusterId = config.kafkaClusterId();
        this.metrics = new ConnectMetrics(workerId, config, time, this.kafkaClusterId);
        this.executor = executorService;
        this.workerId = workerId;
        this.time = time;
        this.plugins = plugins;
        this.config = config;
        this.connectorClientConfigOverridePolicy = connectorClientConfigOverridePolicy;
        this.workerMetricsGroup = new WorkerMetricsGroup(this.connectors, this.tasks, this.metrics);
        Map<String, String> internalConverterConfig = Collections.singletonMap("schemas.enable", "false");
        this.internalKeyConverter = plugins.newInternalConverter(true, JsonConverter.class.getName(), internalConverterConfig);
        this.internalValueConverter = plugins.newInternalConverter(false, JsonConverter.class.getName(), internalConverterConfig);
        this.globalOffsetBackingStore = globalOffsetBackingStore;
        this.workerConfigTransformer = this.initConfigTransformer();
    }

    private WorkerConfigTransformer initConfigTransformer() {
        List providerNames = this.config.getList("config.providers");
        HashMap<String, ConfigProvider> providerMap = new HashMap<String, ConfigProvider>();
        for (String providerName : providerNames) {
            ConfigProvider configProvider = this.plugins.newConfigProvider(this.config, "config.providers." + providerName, Plugins.ClassLoaderUsage.PLUGINS);
            providerMap.put(providerName, configProvider);
        }
        return new WorkerConfigTransformer(this, providerMap);
    }

    public WorkerConfigTransformer configTransformer() {
        return this.workerConfigTransformer;
    }

    protected Herder herder() {
        return this.herder;
    }

    public void start() {
        log.info("Worker starting");
        this.globalOffsetBackingStore.start();
        this.sourceTaskOffsetCommitter = this.config.exactlyOnceSourceEnabled() ? Optional.empty() : Optional.of(new SourceTaskOffsetCommitter(this.config));
        this.connectorStatusMetricsGroup = new ConnectorStatusMetricsGroup(this.metrics, this.tasks, this.herder);
        log.info("Worker started");
    }

    public void stop() {
        log.info("Worker stopping");
        long started = this.time.milliseconds();
        long limit = started + this.config.getLong("task.shutdown.graceful.timeout.ms");
        if (!this.connectors.isEmpty()) {
            log.warn("Shutting down connectors {} uncleanly; herder should have shut down connectors before the Worker is stopped", this.connectors.keySet());
            this.stopAndAwaitConnectors();
        }
        if (!this.tasks.isEmpty()) {
            log.warn("Shutting down tasks {} uncleanly; herder should have shut down tasks before the Worker is stopped", this.tasks.keySet());
            this.stopAndAwaitTasks();
        }
        long timeoutMs = limit - this.time.milliseconds();
        this.sourceTaskOffsetCommitter.ifPresent(committer -> committer.close(timeoutMs));
        this.globalOffsetBackingStore.stop();
        this.metrics.stop();
        log.info("Worker stopped");
        this.workerMetricsGroup.close();
        this.connectorStatusMetricsGroup.close();
        this.workerConfigTransformer.close();
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(EXECUTOR_SHUTDOWN_TERMINATION_TIMEOUT_MS, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(EXECUTOR_SHUTDOWN_TERMINATION_TIMEOUT_MS, TimeUnit.MILLISECONDS)) {
                    log.error("Executor did not terminate in time");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void startConnector(String connName, Map<String, String> connProps, CloseableConnectorContext ctx, ConnectorStatus.Listener statusListener, TargetState initialState, Callback<TargetState> onConnectorStateChange) {
        ConnectorStatus.Listener connectorStatusListener = this.workerMetricsGroup.wrapStatusListener(statusListener);
        try (LoggingContext loggingContext = LoggingContext.forConnector(connName);){
            WorkerConnector workerConnector;
            if (this.connectors.containsKey(connName)) {
                onConnectorStateChange.onCompletion(new ConnectException("Connector with name " + connName + " already exists"), null);
                return;
            }
            String connClass = connProps.get("connector.class");
            ClassLoader connectorLoader = this.plugins.connectorLoader(connClass);
            try (LoaderSwap loaderSwap = this.plugins.withClassLoader(connectorLoader);){
                ConnectorOffsetBackingStore offsetStore;
                OffsetStorageReaderImpl offsetReader;
                ConnectorConfig connConfig;
                log.info("Creating connector {} of type {}", (Object)connName, (Object)connClass);
                Connector connector = this.plugins.newConnector(connClass);
                if (ConnectUtils.isSinkConnector(connector)) {
                    connConfig = new SinkConnectorConfig(this.plugins, connProps);
                    offsetReader = null;
                    offsetStore = null;
                } else {
                    SourceConnectorConfig sourceConfig = new SourceConnectorConfig(this.plugins, connProps, this.config.topicCreationEnable());
                    connConfig = sourceConfig;
                    offsetStore = this.config.exactlyOnceSourceEnabled() ? this.offsetStoreForExactlyOnceSourceConnector(sourceConfig, connName, connector) : this.offsetStoreForRegularSourceConnector(sourceConfig, connName, connector);
                    offsetStore.configure(this.config);
                    offsetReader = new OffsetStorageReaderImpl(offsetStore, connName, this.internalKeyConverter, this.internalValueConverter);
                }
                workerConnector = new WorkerConnector(connName, connector, connConfig, ctx, this.metrics, connectorStatusListener, offsetReader, offsetStore, connectorLoader);
                log.info("Instantiated connector {} with version {} of type {}", new Object[]{connName, connector.version(), connector.getClass()});
                workerConnector.transitionTo(initialState, onConnectorStateChange);
            }
            catch (Throwable t) {
                log.error("Failed to start connector {}", (Object)connName, (Object)t);
                connectorStatusListener.onFailure(connName, t);
                onConnectorStateChange.onCompletion(t, null);
                if (loggingContext != null) {
                    if (var9_9 != null) {
                        try {
                            loggingContext.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        loggingContext.close();
                    }
                }
                return;
            }
            WorkerConnector existing = this.connectors.putIfAbsent(connName, workerConnector);
            if (existing != null) {
                onConnectorStateChange.onCompletion(new ConnectException("Connector with name " + connName + " already exists"), null);
                return;
            }
            this.executor.submit(this.plugins.withClassLoader(connectorLoader, workerConnector));
            log.info("Finished creating connector {}", (Object)connName);
        }
    }

    public boolean isSinkConnector(String connName) {
        WorkerConnector workerConnector = (WorkerConnector)this.connectors.get(connName);
        if (workerConnector == null) {
            throw new ConnectException("Connector " + connName + " not found in this worker.");
        }
        try (LoaderSwap loaderSwap = this.plugins.withClassLoader(workerConnector.loader());){
            boolean bl = workerConnector.isSinkConnector();
            return bl;
        }
    }

    public List<Map<String, String>> connectorTaskConfigs(String connName, ConnectorConfig connConfig) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try (LoggingContext loggingContext = LoggingContext.forConnector(connName);){
            log.trace("Reconfiguring connector tasks for {}", (Object)connName);
            WorkerConnector workerConnector = (WorkerConnector)this.connectors.get(connName);
            if (workerConnector == null) {
                throw new ConnectException("Connector " + connName + " not found in this worker.");
            }
            int maxTasks = connConfig.getInt("tasks.max");
            Map connOriginals = connConfig.originalsStrings();
            Connector connector = workerConnector.connector();
            try (LoaderSwap loaderSwap = this.plugins.withClassLoader(workerConnector.loader());){
                String taskClassName = connector.taskClass().getName();
                for (Map taskProps : connector.taskConfigs(maxTasks)) {
                    HashMap<String, String> taskConfig = new HashMap<String, String>(taskProps);
                    taskConfig.put("task.class", taskClassName);
                    if (connOriginals.containsKey("topics")) {
                        taskConfig.put("topics", (String)connOriginals.get("topics"));
                    }
                    if (connOriginals.containsKey("topics.regex")) {
                        taskConfig.put("topics.regex", (String)connOriginals.get("topics.regex"));
                    }
                    result.add(taskConfig);
                }
            }
        }
        return result;
    }

    private void stopConnector(String connName) {
        try (LoggingContext loggingContext = LoggingContext.forConnector(connName);){
            WorkerConnector workerConnector = (WorkerConnector)this.connectors.get(connName);
            log.info("Stopping connector {}", (Object)connName);
            if (workerConnector == null) {
                log.warn("Ignoring stop request for unowned connector {}", (Object)connName);
                return;
            }
            try (LoaderSwap loaderSwap = this.plugins.withClassLoader(workerConnector.loader());){
                workerConnector.shutdown();
            }
        }
    }

    private void stopConnectors(Collection<String> ids) {
        for (String connector : ids) {
            this.stopConnector(connector);
        }
    }

    private void awaitStopConnector(String connName, long timeout) {
        try (LoggingContext loggingContext = LoggingContext.forConnector(connName);){
            WorkerConnector connector = (WorkerConnector)this.connectors.remove(connName);
            if (connector == null) {
                log.warn("Ignoring await stop request for non-present connector {}", (Object)connName);
                return;
            }
            if (!connector.awaitShutdown(timeout)) {
                log.error("Connector '{}' failed to properly shut down, has become unresponsive, and may be consuming external resources. Correct the configuration for this connector or remove the connector. After fixing the connector, it may be necessary to restart this worker to release any consumed resources.", (Object)connName);
                connector.cancel();
            } else {
                log.debug("Graceful stop of connector {} succeeded.", (Object)connName);
            }
        }
    }

    private void awaitStopConnectors(Collection<String> ids) {
        long now = this.time.milliseconds();
        long deadline = now + CONNECTOR_GRACEFUL_SHUTDOWN_TIMEOUT_MS;
        for (String id : ids) {
            long remaining = Math.max(0L, deadline - this.time.milliseconds());
            this.awaitStopConnector(id, remaining);
        }
    }

    public void stopAndAwaitConnectors() {
        this.stopAndAwaitConnectors(new ArrayList<String>(this.connectors.keySet()));
    }

    public void stopAndAwaitConnectors(Collection<String> ids) {
        this.stopConnectors(ids);
        this.awaitStopConnectors(ids);
    }

    public void stopAndAwaitConnector(String connName) {
        this.stopConnector(connName);
        this.awaitStopConnectors(Collections.singletonList(connName));
    }

    public Set<String> connectorNames() {
        return this.connectors.keySet();
    }

    public boolean isRunning(String connName) {
        WorkerConnector workerConnector = (WorkerConnector)this.connectors.get(connName);
        return workerConnector != null && workerConnector.isRunning();
    }

    public boolean startSinkTask(ConnectorTaskId id, ClusterConfigState configState, Map<String, String> connProps, Map<String, String> taskProps, TaskStatus.Listener statusListener, TargetState initialState) {
        return this.startTask(id, connProps, taskProps, statusListener, new SinkTaskBuilder(id, configState, statusListener, initialState));
    }

    public boolean startSourceTask(ConnectorTaskId id, ClusterConfigState configState, Map<String, String> connProps, Map<String, String> taskProps, TaskStatus.Listener statusListener, TargetState initialState) {
        return this.startTask(id, connProps, taskProps, statusListener, new SourceTaskBuilder(id, configState, statusListener, initialState));
    }

    public boolean startExactlyOnceSourceTask(ConnectorTaskId id, ClusterConfigState configState, Map<String, String> connProps, Map<String, String> taskProps, TaskStatus.Listener statusListener, TargetState initialState, Runnable preProducerCheck, Runnable postProducerCheck) {
        return this.startTask(id, connProps, taskProps, statusListener, new ExactlyOnceSourceTaskBuilder(id, configState, statusListener, initialState, preProducerCheck, postProducerCheck));
    }

    private boolean startTask(ConnectorTaskId id, Map<String, String> connProps, Map<String, String> taskProps, TaskStatus.Listener statusListener, TaskBuilder taskBuilder) {
        TaskStatus.Listener taskStatusListener = this.workerMetricsGroup.wrapStatusListener(statusListener);
        try (LoggingContext loggingContext = LoggingContext.forTask(id);){
            WorkerTask workerTask;
            log.info("Creating task {}", (Object)id);
            if (this.tasks.containsKey(id)) {
                throw new ConnectException("Task already exists in this worker: " + id);
            }
            this.connectorStatusMetricsGroup.recordTaskAdded(id);
            String connType = connProps.get("connector.class");
            ClassLoader connectorLoader = this.plugins.connectorLoader(connType);
            try (LoaderSwap loaderSwap = this.plugins.withClassLoader(connectorLoader);){
                ConnectorConfig connConfig = new ConnectorConfig(this.plugins, connProps);
                TaskConfig taskConfig = new TaskConfig(taskProps);
                Class<Task> taskClass = taskConfig.getClass("task.class").asSubclass(Task.class);
                Task task = this.plugins.newTask(taskClass);
                log.info("Instantiated task {} with version {} of type {}", new Object[]{id, task.version(), taskClass.getName()});
                Converter keyConverter = this.plugins.newConverter(connConfig, "key.converter", Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
                Converter valueConverter = this.plugins.newConverter(connConfig, "value.converter", Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
                HeaderConverter headerConverter = this.plugins.newHeaderConverter(connConfig, "header.converter", Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
                if (keyConverter == null) {
                    keyConverter = this.plugins.newConverter(this.config, "key.converter", Plugins.ClassLoaderUsage.PLUGINS);
                    log.info("Set up the key converter {} for task {} using the worker config", keyConverter.getClass(), (Object)id);
                } else {
                    log.info("Set up the key converter {} for task {} using the connector config", keyConverter.getClass(), (Object)id);
                }
                if (valueConverter == null) {
                    valueConverter = this.plugins.newConverter(this.config, "value.converter", Plugins.ClassLoaderUsage.PLUGINS);
                    log.info("Set up the value converter {} for task {} using the worker config", valueConverter.getClass(), (Object)id);
                } else {
                    log.info("Set up the value converter {} for task {} using the connector config", valueConverter.getClass(), (Object)id);
                }
                if (headerConverter == null) {
                    headerConverter = this.plugins.newHeaderConverter(this.config, "header.converter", Plugins.ClassLoaderUsage.PLUGINS);
                    log.info("Set up the header converter {} for task {} using the worker config", headerConverter.getClass(), (Object)id);
                } else {
                    log.info("Set up the header converter {} for task {} using the connector config", headerConverter.getClass(), (Object)id);
                }
                workerTask = taskBuilder.withTask(task).withConnectorConfig(connConfig).withKeyConverter(keyConverter).withValueConverter(valueConverter).withHeaderConverter(headerConverter).withClassloader(connectorLoader).build();
                workerTask.initialize(taskConfig);
            }
            catch (Throwable t) {
                log.error("Failed to start task {}", (Object)id, (Object)t);
                this.connectorStatusMetricsGroup.recordTaskRemoved(id);
                taskStatusListener.onFailure(id, t);
                boolean bl = false;
                if (loggingContext != null) {
                    if (var9_8 != null) {
                        try {
                            loggingContext.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        loggingContext.close();
                    }
                }
                return bl;
            }
            WorkerTask existing = this.tasks.putIfAbsent(id, workerTask);
            if (existing != null) {
                throw new ConnectException("Task already exists in this worker: " + id);
            }
            this.executor.submit(this.plugins.withClassLoader(connectorLoader, workerTask));
            if (workerTask instanceof WorkerSourceTask) {
                this.sourceTaskOffsetCommitter.ifPresent(committer -> committer.schedule(id, (WorkerSourceTask)workerTask));
            }
            boolean bl = true;
            return bl;
        }
    }

    public KafkaFuture<Void> fenceZombies(String connName, int numTasks, Map<String, String> connProps) {
        return this.fenceZombies(connName, numTasks, connProps, Admin::create);
    }

    /*
     * Exception decompiling
     */
    KafkaFuture<Void> fenceZombies(String connName, int numTasks, Map<String, String> connProps, Function<Map<String, Object>, Admin> adminFactory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Map<String, Object> exactlyOnceSourceTaskProducerConfigs(ConnectorTaskId id, WorkerConfig config, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, String clusterId) {
        boolean workerProducerIdempotenceConfigured;
        Map<String, Object> result = Worker.baseProducerConfigs(id.connector(), "connector-producer-" + id, config, connConfig, connectorClass, connectorClientConfigOverridePolicy, clusterId);
        boolean connectorProducerIdempotenceConfigured = connConfig.originals().containsKey("producer.override.enable.idempotence");
        if (!connectorProducerIdempotenceConfigured && !(workerProducerIdempotenceConfigured = config.originals().containsKey("producer.enable.idempotence"))) {
            result.remove("enable.idempotence");
        }
        ConnectUtils.ensureProperty(result, "enable.idempotence", "true", "for connectors when exactly-once source support is enabled", false);
        String transactionalId = Worker.taskTransactionalId(config.groupId(), id.connector(), id.task());
        ConnectUtils.ensureProperty(result, "transactional.id", transactionalId, "for connectors when exactly-once source support is enabled", true);
        return result;
    }

    static Map<String, Object> baseProducerConfigs(String connName, String defaultClientId, WorkerConfig config, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, String clusterId) {
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.put("bootstrap.servers", config.bootstrapServers());
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("max.block.ms", Long.toString(Long.MAX_VALUE));
        producerProps.put("enable.idempotence", "false");
        producerProps.put("acks", "all");
        producerProps.put("max.in.flight.requests.per.connection", "1");
        producerProps.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        producerProps.put("client.id", defaultClientId);
        producerProps.putAll(config.originalsWithPrefix("producer."));
        ConnectUtils.addMetricsContextProperties(producerProps, config, clusterId);
        Map<String, Object> producerOverrides = Worker.connectorClientConfigOverrides(connName, connConfig, connectorClass, "producer.override.", ConnectorType.SOURCE, ConnectorClientConfigRequest.ClientType.PRODUCER, connectorClientConfigOverridePolicy);
        producerProps.putAll(producerOverrides);
        return producerProps;
    }

    static Map<String, Object> exactlyOnceSourceOffsetsConsumerConfigs(String connName, String defaultClientId, WorkerConfig config, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, String clusterId) {
        Map<String, Object> result = Worker.baseConsumerConfigs(connName, defaultClientId, config, connConfig, connectorClass, connectorClientConfigOverridePolicy, clusterId, ConnectorType.SOURCE);
        ConnectUtils.ensureProperty(result, "isolation.level", IsolationLevel.READ_COMMITTED.name().toLowerCase(Locale.ROOT), "for source connectors' offset consumers when exactly-once source support is enabled", false);
        return result;
    }

    static Map<String, Object> regularSourceOffsetsConsumerConfigs(String connName, String defaultClientId, WorkerConfig config, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, String clusterId) {
        Map<String, Object> result = Worker.baseConsumerConfigs(connName, defaultClientId, config, connConfig, connectorClass, connectorClientConfigOverridePolicy, clusterId, ConnectorType.SOURCE);
        result.putIfAbsent("isolation.level", IsolationLevel.READ_COMMITTED.toString().toLowerCase(Locale.ROOT));
        return result;
    }

    static Map<String, Object> baseConsumerConfigs(String connName, String defaultClientId, WorkerConfig config, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, String clusterId, ConnectorType connectorType) {
        HashMap<String, Object> consumerProps = new HashMap<String, Object>();
        consumerProps.put("group.id", SinkUtils.consumerGroupId(connName));
        consumerProps.put("client.id", defaultClientId);
        consumerProps.put("bootstrap.servers", config.bootstrapServers());
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.putAll(config.originalsWithPrefix("consumer."));
        ConnectUtils.addMetricsContextProperties(consumerProps, config, clusterId);
        Map<String, Object> consumerOverrides = Worker.connectorClientConfigOverrides(connName, connConfig, connectorClass, "consumer.override.", connectorType, ConnectorClientConfigRequest.ClientType.CONSUMER, connectorClientConfigOverridePolicy);
        consumerProps.putAll(consumerOverrides);
        return consumerProps;
    }

    static Map<String, Object> adminConfigs(String connName, String defaultClientId, WorkerConfig config, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy, String clusterId, ConnectorType connectorType) {
        HashMap<String, Object> adminProps = new HashMap<String, Object>();
        Map<String, Object> nonPrefixedWorkerConfigs = config.originals().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("admin.") && !((String)e.getKey()).startsWith("producer.") && !((String)e.getKey()).startsWith("consumer.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        adminProps.put("bootstrap.servers", config.bootstrapServers());
        adminProps.put("client.id", defaultClientId);
        adminProps.putAll(nonPrefixedWorkerConfigs);
        adminProps.putAll(config.originalsWithPrefix("admin."));
        Map<String, Object> adminOverrides = Worker.connectorClientConfigOverrides(connName, connConfig, connectorClass, "admin.override.", connectorType, ConnectorClientConfigRequest.ClientType.ADMIN, connectorClientConfigOverridePolicy);
        adminProps.putAll(adminOverrides);
        ConnectUtils.addMetricsContextProperties(adminProps, config, clusterId);
        return adminProps;
    }

    private static Map<String, Object> connectorClientConfigOverrides(String connName, ConnectorConfig connConfig, Class<? extends Connector> connectorClass, String clientConfigPrefix, ConnectorType connectorType, ConnectorClientConfigRequest.ClientType clientType, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        Map clientOverrides = connConfig.originalsWithPrefix(clientConfigPrefix);
        ConnectorClientConfigRequest connectorClientConfigRequest = new ConnectorClientConfigRequest(connName, connectorType, connectorClass, clientOverrides, clientType);
        List configValues = connectorClientConfigOverridePolicy.validate(connectorClientConfigRequest);
        List errorConfigs = configValues.stream().filter(configValue -> configValue.errorMessages().size() > 0).collect(Collectors.toList());
        if (errorConfigs.size() > 0) {
            throw new ConnectException("Client Config Overrides not allowed " + errorConfigs);
        }
        return clientOverrides;
    }

    private String taskTransactionalId(ConnectorTaskId id) {
        return Worker.taskTransactionalId(this.config.groupId(), id.connector(), id.task());
    }

    public static String taskTransactionalId(String groupId, String connector, int taskId) {
        return String.format("%s-%s-%d", groupId, connector, taskId);
    }

    ErrorHandlingMetrics errorHandlingMetrics(ConnectorTaskId id) {
        return new ErrorHandlingMetrics(id, this.metrics);
    }

    private List<ErrorReporter> sinkTaskReporters(ConnectorTaskId id, SinkConnectorConfig connConfig, ErrorHandlingMetrics errorHandlingMetrics, Class<? extends Connector> connectorClass) {
        ArrayList<ErrorReporter> reporters = new ArrayList<ErrorReporter>();
        LogReporter logReporter = new LogReporter(id, connConfig, errorHandlingMetrics);
        reporters.add(logReporter);
        String topic = connConfig.dlqTopicName();
        if (topic != null && !topic.isEmpty()) {
            Map<String, Object> producerProps = Worker.baseProducerConfigs(id.connector(), "connector-dlq-producer-" + id, this.config, connConfig, connectorClass, this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
            Map<String, Object> adminProps = Worker.adminConfigs(id.connector(), "connector-dlq-adminclient-", this.config, connConfig, connectorClass, this.connectorClientConfigOverridePolicy, this.kafkaClusterId, ConnectorType.SINK);
            DeadLetterQueueReporter reporter = DeadLetterQueueReporter.createAndSetup(adminProps, id, connConfig, producerProps, errorHandlingMetrics);
            reporters.add(reporter);
        }
        return reporters;
    }

    private List<ErrorReporter> sourceTaskReporters(ConnectorTaskId id, ConnectorConfig connConfig, ErrorHandlingMetrics errorHandlingMetrics) {
        ArrayList<ErrorReporter> reporters = new ArrayList<ErrorReporter>();
        LogReporter logReporter = new LogReporter(id, connConfig, errorHandlingMetrics);
        reporters.add(logReporter);
        return reporters;
    }

    private WorkerErrantRecordReporter createWorkerErrantRecordReporter(SinkConnectorConfig connConfig, RetryWithToleranceOperator retryWithToleranceOperator, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter) {
        if (connConfig.enableErrantRecordReporter()) {
            return new WorkerErrantRecordReporter(retryWithToleranceOperator, keyConverter, valueConverter, headerConverter);
        }
        return null;
    }

    private void stopTask(ConnectorTaskId taskId) {
        try (LoggingContext loggingContext = LoggingContext.forTask(taskId);){
            WorkerTask task = (WorkerTask)this.tasks.get(taskId);
            if (task == null) {
                log.warn("Ignoring stop request for unowned task {}", (Object)taskId);
                return;
            }
            log.info("Stopping task {}", (Object)task.id());
            if (task instanceof WorkerSourceTask) {
                this.sourceTaskOffsetCommitter.ifPresent(committer -> committer.remove(task.id()));
            }
            try (LoaderSwap loaderSwap = this.plugins.withClassLoader(task.loader());){
                task.stop();
            }
        }
    }

    private void stopTasks(Collection<ConnectorTaskId> ids) {
        for (ConnectorTaskId taskId : ids) {
            this.stopTask(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitStopTask(ConnectorTaskId taskId, long timeout) {
        try (LoggingContext loggingContext = LoggingContext.forTask(taskId);){
            WorkerTask task = (WorkerTask)this.tasks.remove(taskId);
            if (task == null) {
                log.warn("Ignoring await stop request for non-present task {}", (Object)taskId);
                return;
            }
            if (!task.awaitStop(timeout)) {
                log.error("Graceful stop of task {} failed.", (Object)task.id());
                task.cancel();
            } else {
                log.debug("Graceful stop of task {} succeeded.", (Object)task.id());
            }
            try {
                task.removeMetrics();
            }
            finally {
                this.connectorStatusMetricsGroup.recordTaskRemoved(taskId);
            }
        }
    }

    private void awaitStopTasks(Collection<ConnectorTaskId> ids) {
        long now = this.time.milliseconds();
        long deadline = now + this.config.getLong("task.shutdown.graceful.timeout.ms");
        for (ConnectorTaskId id : ids) {
            long remaining = Math.max(0L, deadline - this.time.milliseconds());
            this.awaitStopTask(id, remaining);
        }
    }

    public void stopAndAwaitTasks() {
        this.stopAndAwaitTasks(new ArrayList<ConnectorTaskId>(this.tasks.keySet()));
    }

    public void stopAndAwaitTasks(Collection<ConnectorTaskId> ids) {
        this.stopTasks(ids);
        this.awaitStopTasks(ids);
    }

    public void stopAndAwaitTask(ConnectorTaskId taskId) {
        this.stopTask(taskId);
        this.awaitStopTasks(Collections.singletonList(taskId));
    }

    public Set<ConnectorTaskId> taskIds() {
        return this.tasks.keySet();
    }

    public Converter getInternalKeyConverter() {
        return this.internalKeyConverter;
    }

    public Converter getInternalValueConverter() {
        return this.internalValueConverter;
    }

    public Plugins getPlugins() {
        return this.plugins;
    }

    public String workerId() {
        return this.workerId;
    }

    public boolean isTopicCreationEnabled() {
        return this.config.topicCreationEnable();
    }

    public ConnectMetrics metrics() {
        return this.metrics;
    }

    public void setTargetState(String connName, TargetState state, Callback<TargetState> stateChangeCallback) {
        log.info("Setting connector {} state to {}", (Object)connName, (Object)state);
        WorkerConnector workerConnector = (WorkerConnector)this.connectors.get(connName);
        if (workerConnector != null) {
            try (LoaderSwap loaderSwap = this.plugins.withClassLoader(workerConnector.loader());){
                workerConnector.transitionTo(state, stateChangeCallback);
            }
        }
        for (Map.Entry taskEntry : this.tasks.entrySet()) {
            if (!((ConnectorTaskId)taskEntry.getKey()).connector().equals(connName)) continue;
            WorkerTask workerTask = (WorkerTask)taskEntry.getValue();
            LoaderSwap loaderSwap = this.plugins.withClassLoader(workerTask.loader());
            Throwable throwable = null;
            try {
                workerTask.transitionTo(state);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (loaderSwap == null) continue;
                if (throwable != null) {
                    try {
                        loaderSwap.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                loaderSwap.close();
            }
        }
    }

    ConnectorStatusMetricsGroup connectorStatusMetricsGroup() {
        return this.connectorStatusMetricsGroup;
    }

    WorkerMetricsGroup workerMetricsGroup() {
        return this.workerMetricsGroup;
    }

    ConnectorOffsetBackingStore offsetStoreForRegularSourceConnector(SourceConnectorConfig sourceConfig, String connName, Connector connector) {
        boolean usesConnectorSpecificStore;
        String connectorSpecificOffsetsTopic = sourceConfig.offsetsTopic();
        Map<String, Object> producerProps = Worker.baseProducerConfigs(connName, "connector-producer-" + connName, this.config, sourceConfig, connector.getClass(), this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
        boolean bl = usesConnectorSpecificStore = connectorSpecificOffsetsTopic != null && this.config.connectorOffsetsTopicsPermitted();
        if (usesConnectorSpecificStore) {
            Map<String, Object> consumerProps = Worker.regularSourceOffsetsConsumerConfigs(connName, "connector-consumer-" + connName, this.config, sourceConfig, connector.getClass(), this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
            KafkaConsumer consumer = new KafkaConsumer(consumerProps);
            Map<String, Object> adminOverrides = Worker.adminConfigs(connName, "connector-adminclient-" + connName, this.config, sourceConfig, connector.getClass(), this.connectorClientConfigOverridePolicy, this.kafkaClusterId, ConnectorType.SOURCE);
            TopicAdmin admin = new TopicAdmin(adminOverrides);
            KafkaOffsetBackingStore connectorStore = KafkaOffsetBackingStore.forConnector(connectorSpecificOffsetsTopic, (Consumer<byte[], byte[]>)consumer, admin);
            if (this.sameOffsetTopicAsWorker(connectorSpecificOffsetsTopic, producerProps)) {
                return ConnectorOffsetBackingStore.withOnlyConnectorStore(() -> LoggingContext.forConnector(connName), connectorStore, connectorSpecificOffsetsTopic, admin);
            }
            return ConnectorOffsetBackingStore.withConnectorAndWorkerStores(() -> LoggingContext.forConnector(connName), this.globalOffsetBackingStore, connectorStore, connectorSpecificOffsetsTopic, admin);
        }
        return ConnectorOffsetBackingStore.withOnlyWorkerStore(() -> LoggingContext.forConnector(connName), this.globalOffsetBackingStore, this.config.offsetsTopic());
    }

    ConnectorOffsetBackingStore offsetStoreForExactlyOnceSourceConnector(SourceConnectorConfig sourceConfig, String connName, Connector connector) {
        String connectorSpecificOffsetsTopic = Optional.ofNullable(sourceConfig.offsetsTopic()).orElse(this.config.offsetsTopic());
        Map<String, Object> producerProps = Worker.baseProducerConfigs(connName, "connector-producer-" + connName, this.config, sourceConfig, connector.getClass(), this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
        Map<String, Object> consumerProps = Worker.exactlyOnceSourceOffsetsConsumerConfigs(connName, "connector-consumer-" + connName, this.config, sourceConfig, connector.getClass(), this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
        KafkaConsumer consumer = new KafkaConsumer(consumerProps);
        Map<String, Object> adminOverrides = Worker.adminConfigs(connName, "connector-adminclient-" + connName, this.config, sourceConfig, connector.getClass(), this.connectorClientConfigOverridePolicy, this.kafkaClusterId, ConnectorType.SOURCE);
        TopicAdmin admin = new TopicAdmin(adminOverrides);
        KafkaOffsetBackingStore connectorStore = KafkaOffsetBackingStore.forConnector(connectorSpecificOffsetsTopic, (Consumer<byte[], byte[]>)consumer, admin);
        if (this.sameOffsetTopicAsWorker(connectorSpecificOffsetsTopic, producerProps)) {
            return ConnectorOffsetBackingStore.withOnlyConnectorStore(() -> LoggingContext.forConnector(connName), connectorStore, connectorSpecificOffsetsTopic, admin);
        }
        return ConnectorOffsetBackingStore.withConnectorAndWorkerStores(() -> LoggingContext.forConnector(connName), this.globalOffsetBackingStore, connectorStore, connectorSpecificOffsetsTopic, admin);
    }

    ConnectorOffsetBackingStore offsetStoreForRegularSourceTask(ConnectorTaskId id, SourceConnectorConfig sourceConfig, Class<? extends Connector> connectorClass, Producer<byte[], byte[]> producer, Map<String, Object> producerProps, TopicAdmin topicAdmin) {
        String connectorSpecificOffsetsTopic = sourceConfig.offsetsTopic();
        if (this.regularSourceTaskUsesConnectorSpecificOffsetsStore(sourceConfig)) {
            Objects.requireNonNull(topicAdmin, "Source tasks require a non-null topic admin when configured to use their own offsets topic");
            Map<String, Object> consumerProps = Worker.regularSourceOffsetsConsumerConfigs(id.connector(), "connector-consumer-" + id, this.config, sourceConfig, connectorClass, this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
            KafkaConsumer consumer = new KafkaConsumer(consumerProps);
            KafkaOffsetBackingStore connectorStore = KafkaOffsetBackingStore.forTask(sourceConfig.offsetsTopic(), producer, (Consumer<byte[], byte[]>)consumer, topicAdmin);
            if (this.sameOffsetTopicAsWorker(sourceConfig.offsetsTopic(), producerProps)) {
                return ConnectorOffsetBackingStore.withOnlyConnectorStore(() -> LoggingContext.forTask(id), connectorStore, connectorSpecificOffsetsTopic, topicAdmin);
            }
            return ConnectorOffsetBackingStore.withConnectorAndWorkerStores(() -> LoggingContext.forTask(id), this.globalOffsetBackingStore, connectorStore, connectorSpecificOffsetsTopic, topicAdmin);
        }
        return ConnectorOffsetBackingStore.withOnlyWorkerStore(() -> LoggingContext.forTask(id), this.globalOffsetBackingStore, this.config.offsetsTopic());
    }

    ConnectorOffsetBackingStore offsetStoreForExactlyOnceSourceTask(ConnectorTaskId id, SourceConnectorConfig sourceConfig, Class<? extends Connector> connectorClass, Producer<byte[], byte[]> producer, Map<String, Object> producerProps, TopicAdmin topicAdmin) {
        Objects.requireNonNull(topicAdmin, "Source tasks require a non-null topic admin when exactly-once support is enabled");
        Map<String, Object> consumerProps = Worker.exactlyOnceSourceOffsetsConsumerConfigs(id.connector(), "connector-consumer-" + id, this.config, sourceConfig, connectorClass, this.connectorClientConfigOverridePolicy, this.kafkaClusterId);
        KafkaConsumer consumer = new KafkaConsumer(consumerProps);
        String connectorOffsetsTopic = Optional.ofNullable(sourceConfig.offsetsTopic()).orElse(this.config.offsetsTopic());
        KafkaOffsetBackingStore connectorStore = KafkaOffsetBackingStore.forTask(connectorOffsetsTopic, producer, (Consumer<byte[], byte[]>)consumer, topicAdmin);
        if (this.sameOffsetTopicAsWorker(connectorOffsetsTopic, producerProps)) {
            return ConnectorOffsetBackingStore.withOnlyConnectorStore(() -> LoggingContext.forTask(id), connectorStore, connectorOffsetsTopic, topicAdmin);
        }
        return ConnectorOffsetBackingStore.withConnectorAndWorkerStores(() -> LoggingContext.forTask(id), this.globalOffsetBackingStore, connectorStore, connectorOffsetsTopic, topicAdmin);
    }

    private boolean sameOffsetTopicAsWorker(String offsetsTopic, Map<String, Object> producerProps) {
        HashSet workerBootstrapServers = new HashSet(this.config.getList("bootstrap.servers"));
        HashSet producerBootstrapServers = new HashSet();
        try {
            String rawBootstrapServers = producerProps.getOrDefault("bootstrap.servers", "").toString();
            List parsedBootstrapServers = (List)ConfigDef.parseType((String)"bootstrap.servers", (Object)rawBootstrapServers, (ConfigDef.Type)ConfigDef.Type.LIST);
            producerBootstrapServers.addAll(parsedBootstrapServers);
        }
        catch (Exception e) {
            throw new ConnectException("Failed to parse bootstrap servers property in producer config", (Throwable)e);
        }
        return offsetsTopic.equals(this.config.offsetsTopic()) && workerBootstrapServers.equals(producerBootstrapServers);
    }

    private boolean regularSourceTaskUsesConnectorSpecificOffsetsStore(SourceConnectorConfig sourceConfig) {
        return sourceConfig.offsetsTopic() != null && this.config.connectorOffsetsTopicsPermitted();
    }

    private boolean sourceConnectorTopicCreationEnabled(SourceConnectorConfig sourceConfig) {
        return this.config.topicCreationEnable() && sourceConfig.usesTopicCreation();
    }

    private static /* synthetic */ void lambda$fenceZombies$3(int numTasks, String connName, Admin admin, Void ignored, Throwable error) {
        if (error != null) {
            log.debug("Finished fencing out {} task producers for source connector {}", (Object)numTasks, (Object)connName);
        }
        Utils.closeQuietly((AutoCloseable)admin, (String)("Zombie fencing admin for connector " + connName));
    }

    private static /* synthetic */ ConnectorTaskId lambda$fenceZombies$2(String connName, int i) {
        return new ConnectorTaskId(connName, i);
    }

    static class ConnectorStatusMetricsGroup {
        private final ConnectMetrics connectMetrics;
        private final ConnectMetricsRegistry registry;
        private final ConcurrentMap<String, ConnectMetrics.MetricGroup> connectorStatusMetrics = new ConcurrentHashMap<String, ConnectMetrics.MetricGroup>();
        private final Herder herder;
        private final ConcurrentMap<ConnectorTaskId, WorkerTask> tasks;

        protected ConnectorStatusMetricsGroup(ConnectMetrics connectMetrics, ConcurrentMap<ConnectorTaskId, WorkerTask> tasks, Herder herder) {
            this.connectMetrics = connectMetrics;
            this.registry = connectMetrics.registry();
            this.tasks = tasks;
            this.herder = herder;
        }

        protected ConnectMetrics.LiteralSupplier<Long> taskCounter(String connName) {
            return now -> this.tasks.keySet().stream().filter(taskId -> taskId.connector().equals(connName)).count();
        }

        protected ConnectMetrics.LiteralSupplier<Long> taskStatusCounter(String connName, AbstractStatus.State state) {
            return now -> this.tasks.values().stream().filter(task -> task.id().connector().equals(connName) && this.herder.taskStatus(task.id()).state().equalsIgnoreCase(state.toString())).count();
        }

        protected synchronized void recordTaskAdded(ConnectorTaskId connectorTaskId) {
            if (this.connectorStatusMetrics.containsKey(connectorTaskId.connector())) {
                return;
            }
            String connName = connectorTaskId.connector();
            ConnectMetrics.MetricGroup metricGroup = this.connectMetrics.group(this.registry.workerGroupName(), this.registry.connectorTagName(), connName);
            metricGroup.addValueMetric(this.registry.connectorTotalTaskCount, this.taskCounter(connName));
            for (Map.Entry<MetricNameTemplate, AbstractStatus.State> statusMetric : this.registry.connectorStatusMetrics.entrySet()) {
                metricGroup.addValueMetric(statusMetric.getKey(), this.taskStatusCounter(connName, statusMetric.getValue()));
            }
            this.connectorStatusMetrics.put(connectorTaskId.connector(), metricGroup);
        }

        protected synchronized void recordTaskRemoved(ConnectorTaskId connectorTaskId) {
            if (this.tasks.keySet().stream().noneMatch(id -> id.connector().equals(connectorTaskId.connector()))) {
                ((ConnectMetrics.MetricGroup)this.connectorStatusMetrics.get(connectorTaskId.connector())).close();
                this.connectorStatusMetrics.remove(connectorTaskId.connector());
            }
        }

        protected synchronized void close() {
            for (ConnectMetrics.MetricGroup metricGroup : this.connectorStatusMetrics.values()) {
                metricGroup.close();
            }
        }

        protected ConnectMetrics.MetricGroup metricGroup(String connectorId) {
            return (ConnectMetrics.MetricGroup)this.connectorStatusMetrics.get(connectorId);
        }
    }

    class ExactlyOnceSourceTaskBuilder
    extends TaskBuilder {
        private final Runnable preProducerCheck;
        private final Runnable postProducerCheck;

        public ExactlyOnceSourceTaskBuilder(ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState, Runnable preProducerCheck, Runnable postProducerCheck) {
            super(id, configState, statusListener, initialState);
            this.preProducerCheck = preProducerCheck;
            this.postProducerCheck = postProducerCheck;
        }

        @Override
        public WorkerTask doBuild(Task task, ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState, ConnectorConfig connectorConfig, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, ClassLoader classLoader, ErrorHandlingMetrics errorHandlingMetrics, Class<? extends Connector> connectorClass, RetryWithToleranceOperator retryWithToleranceOperator) {
            SourceConnectorConfig sourceConfig = new SourceConnectorConfig(Worker.this.plugins, connectorConfig.originalsStrings(), Worker.this.config.topicCreationEnable());
            retryWithToleranceOperator.reporters(Worker.this.sourceTaskReporters(id, sourceConfig, errorHandlingMetrics));
            TransformationChain<SourceRecord> transformationChain = new TransformationChain<SourceRecord>(sourceConfig.transformations(), retryWithToleranceOperator);
            log.info("Initializing: {}", transformationChain);
            Map<String, Object> producerProps = Worker.exactlyOnceSourceTaskProducerConfigs(id, Worker.this.config, sourceConfig, connectorClass, Worker.this.connectorClientConfigOverridePolicy, Worker.this.kafkaClusterId);
            KafkaProducer producer = new KafkaProducer(producerProps);
            Map<String, Object> adminOverrides = Worker.adminConfigs(id.connector(), "connector-adminclient-" + id, Worker.this.config, sourceConfig, connectorClass, Worker.this.connectorClientConfigOverridePolicy, Worker.this.kafkaClusterId, ConnectorType.SOURCE);
            TopicAdmin topicAdmin = new TopicAdmin(adminOverrides);
            Map<String, TopicCreationGroup> topicCreationGroups = Worker.this.sourceConnectorTopicCreationEnabled(sourceConfig) ? TopicCreationGroup.configuredGroups(sourceConfig) : null;
            ConnectorOffsetBackingStore offsetStore = Worker.this.offsetStoreForExactlyOnceSourceTask(id, sourceConfig, connectorClass, (Producer<byte[], byte[]>)producer, producerProps, topicAdmin);
            offsetStore.configure(Worker.this.config);
            OffsetStorageReaderImpl offsetReader = new OffsetStorageReaderImpl(offsetStore, id.connector(), Worker.this.internalKeyConverter, Worker.this.internalValueConverter);
            OffsetStorageWriter offsetWriter = new OffsetStorageWriter(offsetStore, id.connector(), Worker.this.internalKeyConverter, Worker.this.internalValueConverter);
            return new ExactlyOnceWorkerSourceTask(id, (SourceTask)task, statusListener, initialState, keyConverter, valueConverter, headerConverter, transformationChain, (Producer<byte[], byte[]>)producer, topicAdmin, topicCreationGroups, offsetReader, offsetWriter, offsetStore, Worker.this.config, configState, Worker.this.metrics, errorHandlingMetrics, classLoader, Worker.this.time, retryWithToleranceOperator, Worker.this.herder.statusBackingStore(), sourceConfig, Worker.this.executor, this.preProducerCheck, this.postProducerCheck);
        }
    }

    class SourceTaskBuilder
    extends TaskBuilder {
        public SourceTaskBuilder(ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState) {
            super(id, configState, statusListener, initialState);
        }

        @Override
        public WorkerTask doBuild(Task task, ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState, ConnectorConfig connectorConfig, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, ClassLoader classLoader, ErrorHandlingMetrics errorHandlingMetrics, Class<? extends Connector> connectorClass, RetryWithToleranceOperator retryWithToleranceOperator) {
            SourceConnectorConfig sourceConfig = new SourceConnectorConfig(Worker.this.plugins, connectorConfig.originalsStrings(), Worker.this.config.topicCreationEnable());
            retryWithToleranceOperator.reporters(Worker.this.sourceTaskReporters(id, sourceConfig, errorHandlingMetrics));
            TransformationChain<SourceRecord> transformationChain = new TransformationChain<SourceRecord>(sourceConfig.transformations(), retryWithToleranceOperator);
            log.info("Initializing: {}", transformationChain);
            Map<String, Object> producerProps = Worker.baseProducerConfigs(id.connector(), "connector-producer-" + id, Worker.this.config, sourceConfig, connectorClass, Worker.this.connectorClientConfigOverridePolicy, Worker.this.kafkaClusterId);
            KafkaProducer producer = new KafkaProducer(producerProps);
            TopicAdmin topicAdmin = null;
            boolean topicCreationEnabled = Worker.this.sourceConnectorTopicCreationEnabled(sourceConfig);
            if (topicCreationEnabled || Worker.this.regularSourceTaskUsesConnectorSpecificOffsetsStore(sourceConfig)) {
                Map<String, Object> adminOverrides = Worker.adminConfigs(id.connector(), "connector-adminclient-" + id, Worker.this.config, sourceConfig, connectorClass, Worker.this.connectorClientConfigOverridePolicy, Worker.this.kafkaClusterId, ConnectorType.SOURCE);
                topicAdmin = new TopicAdmin(adminOverrides);
            }
            Map<String, TopicCreationGroup> topicCreationGroups = topicCreationEnabled ? TopicCreationGroup.configuredGroups(sourceConfig) : null;
            ConnectorOffsetBackingStore offsetStore = Worker.this.offsetStoreForRegularSourceTask(id, sourceConfig, connectorClass, (Producer<byte[], byte[]>)producer, producerProps, topicAdmin);
            offsetStore.configure(Worker.this.config);
            OffsetStorageReaderImpl offsetReader = new OffsetStorageReaderImpl(offsetStore, id.connector(), Worker.this.internalKeyConverter, Worker.this.internalValueConverter);
            OffsetStorageWriter offsetWriter = new OffsetStorageWriter(offsetStore, id.connector(), Worker.this.internalKeyConverter, Worker.this.internalValueConverter);
            return new WorkerSourceTask(id, (SourceTask)task, statusListener, initialState, keyConverter, valueConverter, errorHandlingMetrics, headerConverter, transformationChain, (Producer<byte[], byte[]>)producer, topicAdmin, topicCreationGroups, (CloseableOffsetStorageReader)offsetReader, offsetWriter, offsetStore, Worker.this.config, configState, Worker.this.metrics, classLoader, Worker.this.time, retryWithToleranceOperator, Worker.this.herder.statusBackingStore(), (Executor)Worker.this.executor);
        }
    }

    class SinkTaskBuilder
    extends TaskBuilder {
        public SinkTaskBuilder(ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState) {
            super(id, configState, statusListener, initialState);
        }

        @Override
        public WorkerTask doBuild(Task task, ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState, ConnectorConfig connectorConfig, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, ClassLoader classLoader, ErrorHandlingMetrics errorHandlingMetrics, Class<? extends Connector> connectorClass, RetryWithToleranceOperator retryWithToleranceOperator) {
            TransformationChain<SinkRecord> transformationChain = new TransformationChain<SinkRecord>(connectorConfig.transformations(), retryWithToleranceOperator);
            log.info("Initializing: {}", transformationChain);
            SinkConnectorConfig sinkConfig = new SinkConnectorConfig(Worker.this.plugins, connectorConfig.originalsStrings());
            retryWithToleranceOperator.reporters(Worker.this.sinkTaskReporters(id, sinkConfig, errorHandlingMetrics, connectorClass));
            WorkerErrantRecordReporter workerErrantRecordReporter = Worker.this.createWorkerErrantRecordReporter(sinkConfig, retryWithToleranceOperator, keyConverter, valueConverter, headerConverter);
            Map<String, Object> consumerProps = Worker.baseConsumerConfigs(id.connector(), "connector-consumer-" + id, Worker.this.config, connectorConfig, connectorClass, Worker.this.connectorClientConfigOverridePolicy, Worker.this.kafkaClusterId, ConnectorType.SINK);
            KafkaConsumer consumer = new KafkaConsumer(consumerProps);
            return new WorkerSinkTask(id, (SinkTask)task, statusListener, initialState, Worker.this.config, configState, Worker.this.metrics, keyConverter, valueConverter, errorHandlingMetrics, headerConverter, transformationChain, (KafkaConsumer<byte[], byte[]>)consumer, classLoader, Worker.this.time, retryWithToleranceOperator, workerErrantRecordReporter, Worker.this.herder.statusBackingStore());
        }
    }

    abstract class TaskBuilder {
        private final ConnectorTaskId id;
        private final ClusterConfigState configState;
        private final TaskStatus.Listener statusListener;
        private final TargetState initialState;
        private Task task = null;
        private ConnectorConfig connectorConfig = null;
        private Converter keyConverter = null;
        private Converter valueConverter = null;
        private HeaderConverter headerConverter = null;
        private ClassLoader classLoader = null;

        public TaskBuilder(ConnectorTaskId id, ClusterConfigState configState, TaskStatus.Listener statusListener, TargetState initialState) {
            this.id = id;
            this.configState = configState;
            this.statusListener = statusListener;
            this.initialState = initialState;
        }

        public TaskBuilder withTask(Task task) {
            this.task = task;
            return this;
        }

        public TaskBuilder withConnectorConfig(ConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public TaskBuilder withKeyConverter(Converter keyConverter) {
            this.keyConverter = keyConverter;
            return this;
        }

        public TaskBuilder withValueConverter(Converter valueConverter) {
            this.valueConverter = valueConverter;
            return this;
        }

        public TaskBuilder withHeaderConverter(HeaderConverter headerConverter) {
            this.headerConverter = headerConverter;
            return this;
        }

        public TaskBuilder withClassloader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public WorkerTask build() {
            Objects.requireNonNull(this.task, "Task cannot be null");
            Objects.requireNonNull(this.connectorConfig, "Connector config used by task cannot be null");
            Objects.requireNonNull(this.keyConverter, "Key converter used by task cannot be null");
            Objects.requireNonNull(this.valueConverter, "Value converter used by task cannot be null");
            Objects.requireNonNull(this.headerConverter, "Header converter used by task cannot be null");
            Objects.requireNonNull(this.classLoader, "Classloader used by task cannot be null");
            ErrorHandlingMetrics errorHandlingMetrics = Worker.this.errorHandlingMetrics(this.id);
            Class<? extends Connector> connectorClass = Worker.this.plugins.connectorClass(this.connectorConfig.getString("connector.class"));
            RetryWithToleranceOperator retryWithToleranceOperator = new RetryWithToleranceOperator(this.connectorConfig.errorRetryTimeout(), this.connectorConfig.errorMaxDelayInMillis(), this.connectorConfig.errorToleranceType(), Time.SYSTEM, errorHandlingMetrics);
            return this.doBuild(this.task, this.id, this.configState, this.statusListener, this.initialState, this.connectorConfig, this.keyConverter, this.valueConverter, this.headerConverter, this.classLoader, errorHandlingMetrics, connectorClass, retryWithToleranceOperator);
        }

        abstract WorkerTask doBuild(Task var1, ConnectorTaskId var2, ClusterConfigState var3, TaskStatus.Listener var4, TargetState var5, ConnectorConfig var6, Converter var7, Converter var8, HeaderConverter var9, ClassLoader var10, ErrorHandlingMetrics var11, Class<? extends Connector> var12, RetryWithToleranceOperator var13);
    }
}

