/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.fault;

import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExitingFaultHandler
implements FaultHandler {
    private static final Logger log = LoggerFactory.getLogger(ProcessExitingFaultHandler.class);
    private final Runnable action;

    public ProcessExitingFaultHandler() {
        this.action = () -> {};
    }

    public ProcessExitingFaultHandler(Runnable action) {
        this.action = action;
    }

    @Override
    public RuntimeException handleFault(String failureMessage, Throwable cause) {
        if (cause == null) {
            log.error("Encountered fatal fault: {}", (Object)failureMessage);
        } else {
            log.error("Encountered fatal fault: {}", (Object)failureMessage, (Object)cause);
        }
        try {
            this.action.run();
        }
        catch (Throwable e) {
            log.error("Failed to run ProcessExitingFaultHandler action.", e);
        }
        Exit.exit((int)1);
        return null;
    }
}

