/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.overflow;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class MultiOnOverflowKeepLastOp<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<T> dropConsumer;
    private final Function<T, Uni<?>> dropUniMapper;

    public MultiOnOverflowKeepLastOp(Multi<? extends T> upstream, Consumer<T> dropConsumer, Function<T, Uni<?>> dropUniMapper) {
        super(upstream);
        this.dropConsumer = dropConsumer;
        this.dropUniMapper = dropUniMapper;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnOverflowLatestProcessor(downstream));
    }

    class MultiOnOverflowLatestProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicInteger wip;
        private Throwable failure;
        private final AtomicLong requested;
        private volatile boolean done;
        private volatile boolean cancelled;
        private final AtomicReference<T> last;

        MultiOnOverflowLatestProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.wip = new AtomicInteger();
            this.requested = new AtomicLong();
            this.last = new AtomicReference();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T t) {
            this.last.lazySet(t);
            this.drain();
        }

        @Override
        public void onFailure(Throwable f) {
            this.failure = f;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompletion() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                super.cancel();
                if (this.wip.getAndIncrement() == 0) {
                    this.last.lazySet(null);
                }
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicLong req = this.requested;
            do {
                long emitted;
                for (emitted = 0L; emitted != req.get(); ++emitted) {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object v = this.last.getAndSet(null);
                    boolean bl = isEmpty = v == null;
                    if (this.checkTerminated(isDone, isEmpty)) {
                        return;
                    }
                    if (isEmpty) break;
                    this.downstream.onItem(v);
                }
                Object possiblyDropped = this.last.get();
                if (req.get() == 0L && possiblyDropped != null && !this.done) {
                    if (MultiOnOverflowKeepLastOp.this.dropConsumer != null) {
                        this.notifyOnOverflowInvoke(possiblyDropped);
                    } else if (MultiOnOverflowKeepLastOp.this.dropUniMapper != null) {
                        this.notifyOnOverflowCall(possiblyDropped);
                    }
                }
                if (emitted == req.get() && this.checkTerminated(this.done, this.last.get() == null)) {
                    return;
                }
                if (emitted == 0L) continue;
                Subscriptions.subtract(req, emitted);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        private void notifyOnOverflowInvoke(T possiblyDropped) {
            try {
                MultiOnOverflowKeepLastOp.this.dropConsumer.accept(possiblyDropped);
            }
            catch (Throwable failure) {
                super.onFailure(failure);
            }
        }

        private void notifyOnOverflowCall(T possiblyDropped) {
            try {
                Uni<?> uni = ParameterValidation.nonNull(MultiOnOverflowKeepLastOp.this.dropUniMapper.apply(possiblyDropped), "uni");
                uni.subscribe().with(ignored -> {}, x$0 -> super.onFailure((Throwable)x$0));
            }
            catch (Throwable failure) {
                super.onFailure(failure);
            }
        }

        boolean checkTerminated(boolean wasDone, boolean wasEmpty) {
            if (this.cancelled) {
                this.last.lazySet(null);
                return true;
            }
            if (wasDone) {
                if (this.failure != null) {
                    this.last.lazySet(null);
                    super.onFailure(this.failure);
                    return true;
                }
                if (wasEmpty) {
                    super.onCompletion();
                    return true;
                }
            }
            return false;
        }
    }
}

