/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis.offset;

import io.debezium.config.Configuration;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.offset.RedisOffsetBackingStore;
import io.debezium.storage.redis.offset.RedisOffsetBackingStoreConfig;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;

@Testcontainers
class RedisOffsetBackingStoreTest {
    @Container
    public GenericContainer redis = new GenericContainer(DockerImageName.parse((String)"redis:5.0.3-alpine")).withExposedPorts(new Integer[]{6379});
    private static final String PROP_PREFIX = "offset.storage.redis.";
    private static final String REDIS_CONTAINER_IMAGE = "redis:5.0.3-alpine";
    private static final String NEW_LINE = "\n";
    private String address;
    private int port;

    RedisOffsetBackingStoreTest() {
    }

    @BeforeEach
    public void setUp() {
        this.redis.start();
        this.address = this.redis.getHost();
        this.port = this.redis.getFirstMappedPort();
    }

    @AfterEach
    public void tearDown() {
        if (this.redis != null) {
            this.redis.stop();
        }
    }

    @Test
    public void testRedisConnection() throws InterruptedException {
        RedisOffsetBackingStoreConfig config = this.getRedisOffsetBackingStoreConfig();
        RedisOffsetBackingStore redisOffsetBackingStore = new RedisOffsetBackingStore();
        redisOffsetBackingStore.configure(config);
        redisOffsetBackingStore.startNoLoad();
        RedisClient client = redisOffsetBackingStore.getRedisClient();
        int clientsNum = (int)this.getClientsNumber("debezium:offsets", client);
        assert (clientsNum == 1);
        RedisClient mockClient = (RedisClient)Mockito.spy((Object)client);
        Mockito.when((Object)mockClient.hgetAll(ArgumentMatchers.anyString())).thenThrow(RedisClientConnectionException.class);
        redisOffsetBackingStore.setRedisClient(mockClient);
        redisOffsetBackingStore.load();
        client = redisOffsetBackingStore.getRedisClient();
        clientsNum = (int)this.getClientsNumber("debezium:offsets", client);
        assert (clientsNum == 1);
        redisOffsetBackingStore.stop();
        assert (redisOffsetBackingStore.getRedisClient() == null);
    }

    private long getClientsNumber(String name, RedisClient client) {
        return Arrays.stream(client.clientList().split(NEW_LINE)).filter(entry -> entry.contains(name)).count();
    }

    private RedisOffsetBackingStoreConfig getRedisOffsetBackingStoreConfig() {
        HashMap<String, CallSite> dummyConfig = new HashMap<String, CallSite>();
        dummyConfig.put("offset.storage.redis.address", (CallSite)((Object)(this.address + ":" + this.port)));
        return new RedisOffsetBackingStoreConfig(Configuration.from(dummyConfig));
    }
}

