/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis.history;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.RedisConnection;
import io.debezium.storage.redis.history.RedisSchemaHistoryConfig;
import io.debezium.util.DelayStrategy;
import io.debezium.util.Loggings;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RedisSchemaHistory
extends AbstractSchemaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSchemaHistory.class);
    private Duration initialRetryDelay;
    private Duration maxRetryDelay;
    private final DocumentWriter writer = DocumentWriter.defaultWriter();
    private final DocumentReader reader = DocumentReader.defaultReader();
    private final AtomicBoolean running = new AtomicBoolean();
    private RedisClient client;
    private RedisSchemaHistoryConfig config;

    void connect() {
        RedisConnection redisConnection = new RedisConnection(this.config.getAddress(), this.config.getUser(), this.config.getPassword(), this.config.getConnectionTimeout(), this.config.getSocketTimeout(), this.config.isSslEnabled());
        this.client = redisConnection.getRedisClient("debezium:schema_history", this.config.isWaitEnabled(), this.config.getWaitTimeout(), this.config.isWaitRetryEnabled(), this.config.getWaitRetryDelay());
    }

    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.config = new RedisSchemaHistoryConfig(config);
        this.initialRetryDelay = Duration.ofMillis(this.config.getInitialRetryDelay().intValue());
        this.maxRetryDelay = Duration.ofMillis(this.config.getMaxRetryDelay().intValue());
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
    }

    public synchronized void start() {
        super.start();
        LOGGER.info("Starting RedisSchemaHistory");
        this.connect();
    }

    protected void storeRecord(HistoryRecord record) throws SchemaHistoryException {
        String line;
        if (record == null) {
            return;
        }
        try {
            line = this.writer.write(record.document());
        }
        catch (IOException e) {
            Loggings.logErrorAndTraceRecord((Logger)LOGGER, (Object)record, (String)"Failed to convert record to string", (Throwable)e);
            throw new SchemaHistoryException("Unable to write database schema history record");
        }
        DelayStrategy delayStrategy = DelayStrategy.exponential((Duration)this.initialRetryDelay, (Duration)this.maxRetryDelay);
        boolean completedSuccessfully = false;
        while (!completedSuccessfully) {
            try {
                if (this.client == null) {
                    this.connect();
                }
                this.client.xadd(this.config.getRedisKeyName(), Collections.singletonMap("schema", line));
                LOGGER.trace("Record written to database schema history in Redis: " + line);
                completedSuccessfully = true;
            }
            catch (RedisClientConnectionException e) {
                LOGGER.warn("Attempting to reconnect to Redis");
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Writing to database schema history stream failed", (Throwable)e);
                LOGGER.warn("Will retry");
            }
            if (completedSuccessfully) continue;
            delayStrategy.sleepWhen(!completedSuccessfully);
        }
    }

    public void stop() {
        this.running.set(false);
        if (this.client != null) {
            this.client.disconnect();
        }
        super.stop();
    }

    protected synchronized void recoverRecords(Consumer<HistoryRecord> records) {
        DelayStrategy delayStrategy = DelayStrategy.exponential((Duration)this.initialRetryDelay, (Duration)this.maxRetryDelay);
        boolean completedSuccessfully = false;
        List<Object> entries = new ArrayList();
        while (!completedSuccessfully) {
            try {
                if (this.client == null) {
                    this.connect();
                }
                entries = this.client.xrange(this.config.getRedisKeyName());
                completedSuccessfully = true;
            }
            catch (RedisClientConnectionException e) {
                LOGGER.warn("Attempting to reconnect to Redis");
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Reading from database schema history stream failed with " + e);
                LOGGER.warn("Will retry");
            }
            if (completedSuccessfully) continue;
            delayStrategy.sleepWhen(!completedSuccessfully);
        }
        for (Map item : entries) {
            try {
                records.accept(new HistoryRecord(this.reader.read((String)item.get("schema"))));
            }
            catch (IOException e) {
                LOGGER.error("Failed to convert record to string: {}", (Object)item, (Object)e);
                return;
            }
        }
    }

    public boolean storageExists() {
        return true;
    }

    public boolean exists() {
        return this.client != null && this.client.xlen(this.config.getRedisKeyName()) > 0L;
    }
}

