/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis;

import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.WaitReplicasRedisClient;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WaitReplicasRedisClientTest {
    @Test
    public void xaddOneNoRetry() {
        String result = this.client(false).xadd(null, null);
        Assertions.assertEquals((Object)"2", (Object)result);
    }

    @Test
    public void xaddOneRetry() {
        String result = this.client(true).xadd(null, null);
        Assertions.assertEquals((Object)"0", (Object)result);
    }

    @Test
    public void xaddAllNoRetry() {
        List result = this.client(false).xadd(null);
        Assertions.assertEquals((Object)"2", result.get(0));
    }

    @Test
    public void xaddAllRetry() {
        List result = this.client(true).xadd(null);
        Assertions.assertEquals((Object)"0", result.get(0));
    }

    @Test
    public void xrangeNoRetry() {
        List result = this.client(false).xrange("key");
        Assertions.assertEquals((Object)"2", ((Map)result.get(0)).get("key"));
    }

    @Test
    public void xrangeRetry() {
        List result = this.client(true).xrange("key");
        Assertions.assertEquals((Object)"2", ((Map)result.get(0)).get("key"));
    }

    @Test
    public void xlenNoRetry() {
        long result = this.client(false).xlen("key");
        Assertions.assertEquals((long)2L, (long)result);
    }

    @Test
    public void xlenRetry() {
        long result = this.client(true).xlen("key");
        Assertions.assertEquals((long)2L, (long)result);
    }

    @Test
    public void hgetAllNoRetry() {
        Map result = this.client(false).hgetAll("key");
        Assertions.assertEquals((Object)"2", result.get("key"));
    }

    @Test
    public void hgetAllRetry() {
        Map result = this.client(true).hgetAll("key");
        Assertions.assertEquals((Object)"2", result.get("key"));
    }

    @Test
    public void hsetNoRetry() {
        long result = this.client(false).hset(null, null, null);
        Assertions.assertEquals((long)2L, (long)result);
    }

    @Test
    public void hsetRetry() {
        long result = this.client(true).hset(null, null, null);
        Assertions.assertEquals((long)0L, (long)result);
    }

    @Test
    public void waitUnsupported() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.client(false).waitReplicas(0, 0L));
    }

    private RedisClient client(boolean retry) {
        RedisClientImpl client = new RedisClientImpl(2);
        WaitReplicasRedisClient waitClient = new WaitReplicasRedisClient((RedisClient)client, 1, 1L, retry, 1L);
        return waitClient;
    }

    private static class RedisClientImpl
    implements RedisClient {
        private int errorCount;

        private RedisClientImpl(int errorCount) {
            this.errorCount = errorCount;
        }

        public void disconnect() throws RedisClientConnectionException {
        }

        public void close() throws RedisClientConnectionException {
        }

        public String xadd(String key, Map<String, String> hash) throws RedisClientConnectionException {
            return this.errorCount();
        }

        public List<String> xadd(List<AbstractMap.SimpleEntry<String, Map<String, String>>> hashes) throws RedisClientConnectionException {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.errorCount());
            return result;
        }

        public List<Map<String, String>> xrange(String key) throws RedisClientConnectionException {
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            result.add(Collections.singletonMap(key, this.errorCount()));
            return result;
        }

        public long xlen(String key) throws RedisClientConnectionException {
            return this.errorCount;
        }

        public Map<String, String> hgetAll(String key) throws RedisClientConnectionException {
            return Collections.singletonMap(key, this.errorCount());
        }

        public long hset(byte[] key, byte[] field, byte[] value) throws RedisClientConnectionException {
            return this.errorCount;
        }

        public long waitReplicas(int replicas, long timeout) throws RedisClientConnectionException {
            return replicas + this.errorCount--;
        }

        private String errorCount() {
            return "" + this.errorCount;
        }

        public String info(String section) {
            return "";
        }
    }
}

