/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis.offset;

import io.debezium.config.Field;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.RedisConnection;
import io.smallrye.mutiny.Uni;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOffsetBackingStore
extends MemoryOffsetBackingStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisOffsetBackingStore.class);
    private static final String CONFIGURATION_FIELD_PREFIX_STRING = "offset.storage.redis.";
    public static final Field PROP_ADDRESS = Field.create((String)"offset.storage.redis.address").withDescription("The Redis url that will be used to access the database schema history");
    public static final Field PROP_SSL_ENABLED = Field.create((String)"offset.storage.redis.ssl.enabled").withDescription("Use SSL for Redis connection").withDefault("false");
    public static final Field PROP_USER = Field.create((String)"offset.storage.redis.user").withDescription("The Redis url that will be used to access the database schema history");
    public static final Field PROP_PASSWORD = Field.create((String)"offset.storage.redis.password").withDescription("The Redis url that will be used to access the database schema history");
    public static final String DEFAULT_REDIS_KEY_NAME = "metadata:debezium:offsets";
    public static final Field PROP_KEY_NAME = Field.create((String)"offset.storage.redis.key").withDescription("The Redis key that will be used to store the database schema history").withDefault("metadata:debezium:offsets");
    public static final Integer DEFAULT_RETRY_INITIAL_DELAY = 300;
    public static final Field PROP_RETRY_INITIAL_DELAY = Field.create((String)"offset.storage.redis.retry.initial.delay.ms").withDescription("Initial retry delay (in ms)").withDefault(DEFAULT_RETRY_INITIAL_DELAY.intValue());
    public static final Integer DEFAULT_RETRY_MAX_DELAY = 10000;
    public static final Field PROP_RETRY_MAX_DELAY = Field.create((String)"offset.storage.redis.retry.max.delay.ms").withDescription("Maximum retry delay (in ms)").withDefault(DEFAULT_RETRY_MAX_DELAY.intValue());
    public static final Integer DEFAULT_CONNECTION_TIMEOUT = 2000;
    public static final Field PROP_CONNECTION_TIMEOUT = Field.create((String)"offset.storage.redis.connection.timeout.ms").withDescription("Connection timeout (in ms)").withDefault(DEFAULT_CONNECTION_TIMEOUT.intValue());
    public static final Integer DEFAULT_SOCKET_TIMEOUT = 2000;
    public static final Field PROP_SOCKET_TIMEOUT = Field.create((String)"offset.storage.redis.socket.timeout.ms").withDescription("Socket timeout (in ms)").withDefault(DEFAULT_SOCKET_TIMEOUT.intValue());
    private static final boolean DEFAULT_WAIT_ENABLED = false;
    private static final Field PROP_WAIT_ENABLED = Field.create((String)"offset.storage.redis.wait.enabled").withDescription("Enables wait for replica. In case Redis is configured with a replica shard, this allows to verify that the data has been written to the replica.").withDefault(false);
    private static final long DEFAULT_WAIT_TIMEOUT = 1000L;
    private static final Field PROP_WAIT_TIMEOUT = Field.create((String)"offset.storage.redis.wait.timeout.ms").withDescription("Timeout when wait for replica").withDefault(1000L);
    private static final boolean DEFAULT_WAIT_RETRY_ENABLED = false;
    private static final Field PROP_WAIT_RETRY_ENABLED = Field.create((String)"offset.storage.redis.wait.retry.enabled").withDescription("Enables retry on wait for replica failure").withDefault(false);
    private static final long DEFAULT_WAIT_RETRY_DELAY = 1000L;
    private static final Field PROP_WAIT_RETRY_DELAY = Field.create((String)"offset.storage.redis.wait.retry.delay.ms").withDescription("Delay of retry on wait for replica failure").withDefault(1000L);
    private String redisKeyName;
    private String address;
    private String user;
    private String password;
    private boolean sslEnabled;
    private RedisClient client;
    private Map<String, String> config;
    private Integer initialRetryDelay;
    private Integer maxRetryDelay;
    private Integer connectionTimeout;
    private Integer socketTimeout;
    private boolean waitEnabled;
    private long waitTimeout;
    private boolean waitRetryEnabled;
    private long waitRetryDelay;

    void connect() {
        RedisConnection redisConnection = new RedisConnection(this.address, this.user, this.password, this.connectionTimeout, this.socketTimeout, this.sslEnabled);
        this.client = redisConnection.getRedisClient("debezium:offsets", this.waitEnabled, this.waitTimeout, this.waitRetryEnabled, this.waitRetryDelay);
    }

    public void configure(WorkerConfig config) {
        super.configure(config);
        this.config = config.originalsStrings();
        this.address = this.config.get(PROP_ADDRESS.name());
        this.user = this.config.get(PROP_USER.name());
        this.password = this.config.get(PROP_PASSWORD.name());
        this.sslEnabled = Boolean.parseBoolean(this.config.get(PROP_SSL_ENABLED.name()));
        this.redisKeyName = Optional.ofNullable(this.config.get(PROP_KEY_NAME.name())).orElse(DEFAULT_REDIS_KEY_NAME);
        this.initialRetryDelay = Optional.ofNullable(Integer.getInteger(this.config.get(PROP_RETRY_INITIAL_DELAY.name()))).orElse(DEFAULT_RETRY_INITIAL_DELAY);
        this.maxRetryDelay = Optional.ofNullable(Integer.getInteger(this.config.get(PROP_RETRY_MAX_DELAY.name()))).orElse(DEFAULT_RETRY_MAX_DELAY);
        this.connectionTimeout = Optional.ofNullable(Integer.getInteger(this.config.get(PROP_CONNECTION_TIMEOUT.name()))).orElse(DEFAULT_CONNECTION_TIMEOUT);
        this.socketTimeout = Optional.ofNullable(Integer.getInteger(this.config.get(PROP_SOCKET_TIMEOUT.name()))).orElse(DEFAULT_SOCKET_TIMEOUT);
        this.waitEnabled = Optional.ofNullable(Boolean.getBoolean(this.config.get(PROP_WAIT_ENABLED.name()))).orElse(false);
        this.waitTimeout = Optional.ofNullable(Long.getLong(this.config.get(PROP_WAIT_TIMEOUT.name()))).orElse(1000L);
        this.waitRetryEnabled = Optional.ofNullable(Boolean.getBoolean(this.config.get(PROP_WAIT_RETRY_ENABLED.name()))).orElse(false);
        this.waitRetryDelay = Optional.ofNullable(Long.getLong(this.config.get(PROP_WAIT_RETRY_DELAY.name()))).orElse(1000L);
    }

    public synchronized void start() {
        super.start();
        LOGGER.info("Starting RedisOffsetBackingStore");
        this.connect();
        this.load();
    }

    public synchronized void stop() {
        super.stop();
        LOGGER.info("Stopped RedisOffsetBackingStore");
    }

    private void load() {
        Map offsets = (Map)Uni.createFrom().item(() -> this.client.hgetAll(this.redisKeyName)).onFailure().invoke(f -> {
            LOGGER.warn("Reading from Redis offset store failed with " + f);
            LOGGER.warn("Will retry");
        }).onFailure(RedisClientConnectionException.class).invoke(f -> {
            LOGGER.warn("Attempting to reconnect to Redis");
            this.connect();
        }).onFailure().retry().withBackOff(Duration.ofMillis(this.initialRetryDelay.intValue()), Duration.ofMillis(this.maxRetryDelay.intValue())).indefinitely().invoke(item -> LOGGER.trace("Offsets fetched from Redis: " + item)).await().indefinitely();
        this.data = new HashMap();
        for (Map.Entry mapEntry : offsets.entrySet()) {
            ByteBuffer key = mapEntry.getKey() != null ? ByteBuffer.wrap(((String)mapEntry.getKey()).getBytes()) : null;
            ByteBuffer value = mapEntry.getValue() != null ? ByteBuffer.wrap(((String)mapEntry.getValue()).getBytes()) : null;
            this.data.put(key, value);
        }
    }

    protected void save() {
        for (Map.Entry mapEntry : this.data.entrySet()) {
            byte[] key = mapEntry.getKey() != null ? ((ByteBuffer)mapEntry.getKey()).array() : null;
            byte[] value = mapEntry.getValue() != null ? ((ByteBuffer)mapEntry.getValue()).array() : null;
            Uni.createFrom().item(() -> this.client.hset(this.redisKeyName.getBytes(), key, value)).onFailure().invoke(f -> {
                LOGGER.warn("Writing to Redis offset store failed with " + f);
                LOGGER.warn("Will retry");
            }).onFailure(RedisClientConnectionException.class).invoke(f -> {
                LOGGER.warn("Attempting to reconnect to Redis");
                this.connect();
            }).onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(2L)).indefinitely().invoke(item -> LOGGER.trace("Offsets written to Redis: " + value)).await().indefinitely();
        }
    }
}

