/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.jdbc.history;

import io.debezium.config.Configuration;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryMetrics;
import io.debezium.relational.history.TableChanges;
import io.debezium.storage.jdbc.history.JdbcSchemaHistory;
import io.debezium.storage.jdbc.history.JdbcSchemaHistoryConfig;
import io.debezium.storage.jdbc.history.TestingAntlrDdlParser;
import io.debezium.util.Collect;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcSchemaHistoryTest {
    protected SchemaHistory history;
    String dbFile = "/tmp/test.db";
    static String databaseName = "db";
    static String schemaName = "myschema";
    static String ddl = "CREATE TABLE foo ( first VARCHAR(22) NOT NULL );";
    static Map<String, Object> source;
    static Map<String, Object> position;
    static TableId tableId;
    static Table table;
    static TableChanges tableChanges;
    static HistoryRecord historyRecord;
    static Map<String, Object> position2;
    static TableId tableId2;
    static Table table2;
    static TableChanges tableChanges2;
    static HistoryRecord historyRecord2;
    static DdlParser ddlParser;
    static Instant currentInstant;

    @BeforeClass
    public static void beforeClass() {
        source = Collect.linkMapOf((Object)"server", (Object)"abc");
        position = Collect.linkMapOf((Object)"file", (Object)"x.log", (Object)"positionInt", (Object)100, (Object)"positionLong", (Object)Long.MAX_VALUE, (Object)"entry", (Object)1);
        tableId = new TableId(databaseName, schemaName, "foo");
        table = Table.editor().tableId(tableId).addColumn(Column.editor().name("first").jdbcType(12).type("VARCHAR").length(22).optional(false).create()).setPrimaryKeyNames(new String[]{"first"}).create();
        tableChanges = new TableChanges().create(table);
        historyRecord = new HistoryRecord(source, position, databaseName, schemaName, ddl, tableChanges, currentInstant);
        position2 = Collect.linkMapOf((Object)"file", (Object)"x.log", (Object)"positionInt", (Object)100, (Object)"positionLong", (Object)Long.MAX_VALUE, (Object)"entry", (Object)2);
        tableId2 = new TableId(databaseName, schemaName, "bar");
        table2 = Table.editor().tableId(tableId2).addColumn(Column.editor().name("first").jdbcType(12).type("VARCHAR").length(22).optional(false).create()).setPrimaryKeyNames(new String[]{"first"}).create();
        tableChanges2 = new TableChanges().create(table2);
        historyRecord2 = new HistoryRecord(source, position, databaseName, schemaName, ddl, tableChanges2, currentInstant);
    }

    @Before
    public void beforeEach() {
        this.history = new JdbcSchemaHistory();
        this.history.configure(Configuration.create().with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_JDBC_URL.name(), "jdbc:sqlite:" + this.dbFile).with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_USER.name(), "user").with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_PASSWORD.name(), "pass").build(), null, SchemaHistoryMetrics.NOOP, true);
        this.history.start();
    }

    @After
    public void afterEach() throws IOException {
        if (this.history != null) {
            this.history.stop();
        }
        Files.delete(Paths.get(this.dbFile, new String[0]));
    }

    @Test
    public void shouldSplitDatabaseAndTableName() {
        JdbcSchemaHistory schemaHistory = new JdbcSchemaHistory();
        schemaHistory.configure(Configuration.create().with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_JDBC_URL.name(), "jdbc:sqlite:" + this.dbFile).with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_USER.name(), "user").with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_PASSWORD.name(), "pass").with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_TABLE_NAME.name(), "public.employee").build(), null, SchemaHistoryMetrics.NOOP, true);
        Assert.assertTrue((boolean)schemaHistory.getConfig().getDatabaseName().equalsIgnoreCase("public"));
        Assert.assertTrue((boolean)schemaHistory.getConfig().getTableName().equalsIgnoreCase("employee"));
    }

    @Test
    public void shouldNotFailMultipleInitializeStorage() {
        this.history.initializeStorage();
        this.history.initializeStorage();
        this.history.initializeStorage();
        Assert.assertTrue((boolean)this.history.storageExists());
        Assert.assertFalse((boolean)this.history.exists());
    }

    @Test
    public void shouldRecordChangesAndRecover() throws InterruptedException {
        this.history.record(source, position, databaseName, schemaName, ddl, tableChanges, currentInstant);
        this.history.record(source, position, databaseName, schemaName, ddl, tableChanges, currentInstant);
        Tables tables = new Tables();
        this.history.recover(source, position, tables, ddlParser);
        Assert.assertEquals((long)tables.size(), (long)1L);
        Assert.assertEquals((Object)tables.forTable(tableId), (Object)table);
        this.history.record(source, position2, databaseName, schemaName, ddl, tableChanges2, currentInstant);
        this.history.record(source, position2, databaseName, schemaName, ddl, tableChanges2, currentInstant);
        this.history.stop();
        JdbcSchemaHistory history2 = new JdbcSchemaHistory();
        history2.configure(Configuration.create().with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_JDBC_URL.name(), "jdbc:sqlite:" + this.dbFile).with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_USER.name(), "user").with("schema.history.internal." + JdbcSchemaHistoryConfig.PROP_PASSWORD.name(), "pass").build(), null, SchemaHistoryMetrics.NOOP, true);
        history2.start();
        Assert.assertTrue((boolean)history2.storageExists());
        Assert.assertTrue((boolean)history2.exists());
        Tables tables2 = new Tables();
        history2.recover(source, position2, tables2, ddlParser);
        Assert.assertEquals((long)tables2.size(), (long)2L);
        Assert.assertEquals((Object)tables2.forTable(tableId2), (Object)table2);
    }

    static {
        ddlParser = new TestingAntlrDdlParser();
        currentInstant = Instant.now();
    }
}

