/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.jdbc;

import io.debezium.storage.jdbc.offset.JdbcOffsetBackingStore;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.standalone.StandaloneConfig;
import org.apache.kafka.connect.util.Callback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JdbcOffsetBackingStoreTest {
    private final Map<ByteBuffer, ByteBuffer> firstSet = new HashMap<ByteBuffer, ByteBuffer>();
    private final Map<ByteBuffer, ByteBuffer> secondSet = new HashMap<ByteBuffer, ByteBuffer>();
    JdbcOffsetBackingStore store;
    Map<String, String> props;
    WorkerConfig config;
    File dbFile;

    @Before
    public void setup() throws IOException {
        this.dbFile = File.createTempFile("test-", "db");
        this.store = new JdbcOffsetBackingStore();
        this.props = new HashMap<String, String>();
        this.props.put("offset.storage.file.filename", "dummy");
        this.props.put("offset.storage.jdbc.url", "jdbc:sqlite:" + this.dbFile.getAbsolutePath());
        this.props.put("offset.storage.jdbc.user", "user");
        this.props.put("offset.storage.jdbc.password", "pass");
        this.props.put("offset.storage.jdbc.offset.table.name", "offsets_jdbc");
        this.props.put("offset.storage.jdbc.offset.table.ddl", "CREATE TABLE %s (id VARCHAR(36) NOT NULL, offset_key VARCHAR(1255), offset_val VARCHAR(1255),record_insert_ts TIMESTAMP NOT NULL,record_insert_seq INTEGER NOT NULL)");
        this.props.put("offset.storage.jdbc.offset.table.select", "SELECT id, offset_key, offset_val FROM offsets_jdbc ORDER BY record_insert_ts, record_insert_seq");
        this.props.put("key.converter", "org.apache.kafka.connect.json.JsonConverter");
        this.props.put("value.converter", "org.apache.kafka.connect.json.JsonConverter");
        this.config = new StandaloneConfig(this.props);
        this.store.configure(this.config);
        this.store.start();
        this.firstSet.put(this.store.toByteBuffer("key"), this.store.toByteBuffer("value"));
        this.firstSet.put(null, null);
        this.secondSet.put(this.store.toByteBuffer("key1secondSet"), this.store.toByteBuffer("value1secondSet"));
        this.secondSet.put(this.store.toByteBuffer("key2secondSet"), this.store.toByteBuffer("value2secondSet"));
    }

    @After
    public void teardown() {
        this.dbFile.delete();
    }

    @Test
    public void testInitialize() {
        this.store.start();
        this.store.start();
        this.store.start();
    }

    @Test
    public void testGetSet() throws Exception {
        Callback<Void> cb = new Callback<Void>(){

            public void onCompletion(Throwable error, Void result) {
            }
        };
        this.store.set(this.firstSet, (Callback)cb).get();
        Map values = (Map)this.store.get(Arrays.asList(this.store.toByteBuffer("key"), this.store.toByteBuffer("bad"))).get();
        Assert.assertEquals((Object)this.store.toByteBuffer("value"), values.get(this.store.toByteBuffer("key")));
        Assert.assertNull(values.get(this.store.toByteBuffer("bad")));
    }

    @Test
    public void testSaveRestore() throws Exception {
        Callback<Void> cb = new Callback<Void>(){

            public void onCompletion(Throwable error, Void result) {
            }
        };
        this.store.set(this.firstSet, (Callback)cb).get();
        this.store.set(this.secondSet, (Callback)cb).get();
        this.store.stop();
        JdbcOffsetBackingStore restore = new JdbcOffsetBackingStore();
        restore.configure(this.config);
        restore.start();
        Map values = (Map)restore.get(Collections.singletonList(this.store.toByteBuffer("key"))).get();
        Map values2 = (Map)restore.get(Collections.singletonList(this.store.toByteBuffer("key1secondSet"))).get();
        Map values3 = (Map)restore.get(Collections.singletonList(this.store.toByteBuffer("key2secondSet"))).get();
        Assert.assertEquals((Object)this.store.toByteBuffer("value"), values.get(this.store.toByteBuffer("key")));
        Assert.assertEquals((Object)this.store.toByteBuffer("value1secondSet"), values2.get(this.store.toByteBuffer("key1secondSet")));
        Assert.assertEquals((Object)this.store.toByteBuffer("value2secondSet"), values3.get(this.store.toByteBuffer("key2secondSet")));
    }
}

