/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.jdbc.offset;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.storage.jdbc.JdbcCommonConfig;
import io.debezium.util.Collect;
import java.util.List;

public class JdbcOffsetBackingStoreConfig
extends JdbcCommonConfig {
    public static final String OFFSET_STORAGE_PREFIX = "offset.storage.";
    public static final String PROP_PREFIX = "offset.storage.jdbc.";
    public static final String DEFAULT_TABLE_NAME = "debezium_offset_storage";
    public static final Field PROP_TABLE_NAME = Field.create((String)"offset.storage.jdbc.offset.table.name").withDescription("Name of the table to store offsets").withDefault("debezium_offset_storage");
    public static final String DEFAULT_TABLE_DDL = "CREATE TABLE %s(id VARCHAR(36) NOT NULL, offset_key VARCHAR(1255), offset_val VARCHAR(1255),record_insert_ts TIMESTAMP NOT NULL,record_insert_seq INTEGER NOT NULL)";
    public static final Field PROP_TABLE_DDL = Field.create((String)"offset.storage.jdbc.offset.table.ddl").withDescription("Create table syntax for offset jdbc table").withDefault("CREATE TABLE %s(id VARCHAR(36) NOT NULL, offset_key VARCHAR(1255), offset_val VARCHAR(1255),record_insert_ts TIMESTAMP NOT NULL,record_insert_seq INTEGER NOT NULL)");
    public static final String DEFAULT_TABLE_SELECT = "SELECT id, offset_key, offset_val FROM %s ORDER BY record_insert_ts, record_insert_seq";
    public static final String DEFAULT_TABLE_DELETE = "DELETE FROM %s";
    public static final String DEFAULT_TABLE_INSERT = "INSERT INTO %s(id, offset_key, offset_val, record_insert_ts, record_insert_seq) VALUES ( ?, ?, ?, ?, ? )";
    public static final Field PROP_TABLE_SELECT = Field.create((String)"offset.storage.jdbc.offset.table.select").withDescription("Select syntax to get offset data from jdbc table").withDefault("SELECT id, offset_key, offset_val FROM %s ORDER BY record_insert_ts, record_insert_seq");
    public static final Field PROP_TABLE_DELETE = Field.create((String)"offset.storage.jdbc.offset.table.delete").withDescription("Delete syntax to delete offset data from jdbc table").withDefault("DELETE FROM %s");
    public static final Field PROP_TABLE_INSERT = Field.create((String)"offset.storage.jdbc.offset.table.insert").withDescription("Insert syntax to add offset data to the jdbc table").withDefault("INSERT INTO %s(id, offset_key, offset_val, record_insert_ts, record_insert_seq) VALUES ( ?, ?, ?, ?, ? )");
    private String tableCreate;
    private String tableSelect;
    private String tableDelete;
    private String tableInsert;
    private String tableName;

    public JdbcOffsetBackingStoreConfig(Configuration config) {
        super(config, OFFSET_STORAGE_PREFIX);
    }

    @Override
    protected void init(Configuration config) {
        super.init(config);
        this.tableName = config.getString(PROP_TABLE_NAME);
        this.tableCreate = String.format(config.getString(PROP_TABLE_DDL), this.tableName);
        this.tableSelect = String.format(config.getString(PROP_TABLE_SELECT), this.tableName);
        this.tableInsert = String.format(config.getString(PROP_TABLE_INSERT), this.tableName);
        this.tableDelete = String.format(config.getString(PROP_TABLE_DELETE), this.tableName);
    }

    @Override
    protected List<Field> getAllConfigurationFields() {
        List fields = Collect.arrayListOf((Object)PROP_TABLE_NAME, (Object[])new Field[]{PROP_TABLE_DDL, PROP_TABLE_SELECT, PROP_TABLE_INSERT, PROP_TABLE_DELETE});
        fields.addAll(super.getAllConfigurationFields());
        return fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableCreate() {
        return this.tableCreate;
    }

    public String getTableSelect() {
        return this.tableSelect;
    }

    public String getTableDelete() {
        return this.tableDelete;
    }

    public String getTableInsert() {
        return this.tableInsert;
    }
}

