/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.rocketmq;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class RocketMqContainer
extends GenericContainer<RocketMqContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"apache/rocketmq:4.9.4");
    private static final int defaultBrokerPermission = 6;
    public static final int NAMESRV_PORT = 9876;
    public static final int BROKER_PORT = 10911;

    public RocketMqContainer() {
        super(DEFAULT_IMAGE_NAME);
        this.withExposedPorts(new Integer[]{9876, 10911, 10909});
    }

    protected void configure() {
        Object command = "#!/bin/bash\n";
        command = (String)command + "./mqnamesrv &\n";
        command = (String)command + "./mqbroker -n localhost:9876";
        this.withCommand(new String[]{"sh", "-c", command});
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        ArrayList<String> updateBrokerConfigCommands = new ArrayList<String>();
        updateBrokerConfigCommands.add(this.updateBrokerConfig("brokerIP1", this.getHost()));
        updateBrokerConfigCommands.add(this.updateBrokerConfig("listenPort", this.getMappedPort(10911)));
        updateBrokerConfigCommands.add(this.updateBrokerConfig("brokerPermission", 6));
        String command = String.join((CharSequence)" && ", updateBrokerConfigCommands);
        Container.ExecResult result = null;
        try {
            result = this.execInContainer(new String[]{"/bin/sh", "-c", command});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (result != null && result.getExitCode() != 0) {
            throw new IllegalStateException(result.toString());
        }
    }

    private String updateBrokerConfig(String key, Object val) {
        String brokerAddr = "localhost:10911";
        return "./mqadmin updateBrokerConfig -b localhost:10911 -k " + key + " -v " + val;
    }

    public String getNamesrvAddr() {
        return String.format("%s:%s", this.getHost(), this.getMappedPort(9876));
    }
}

