/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.storage.redis.RedisCommonConfig;
import io.debezium.util.Collect;
import java.util.List;
import java.util.Set;

public class RedisStreamChangeConsumerConfig
extends RedisCommonConfig {
    private static final String PROP_PREFIX = "debezium.sink.";
    private static final int DEFAULT_BATCH_SIZE = 500;
    private static final Field PROP_BATCH_SIZE = Field.create((String)"redis.batch.size").withDefault(500);
    private static final String DEFAULT_NULL_KEY = "default";
    private static final Field PROP_NULL_KEY = Field.create((String)"redis.null.key").withDefault("default");
    private static final String DEFAULT_NULL_VALUE = "default";
    private static final Field PROP_NULL_VALUE = Field.create((String)"redis.null.value").withDefault("default");
    static final String MESSAGE_FORMAT_COMPACT = "compact";
    static final String MESSAGE_FORMAT_EXTENDED = "extended";
    private static final Field PROP_MESSAGE_FORMAT = Field.create((String)"redis.message.format").withAllowedValues(Set.of("compact", "extended")).withDefault("compact");
    private static final int DEFAULT_MEMORY_LIMIT_MB = 0;
    private static final int DEFAULT_BUFFER_FILL_RATE = 30000;
    private static final Field PROP_MEMORY_LIMIT_MB = Field.create((String)"redis.memory.limit.mb").withDefault(0).withValidation(new Field.Validator[]{Field.RangeValidator.atLeast((Number)0)});
    private static final Field PROP_BUFFER_FILL_RATE = Field.create((String)"redis.buffer.fill.rate").withDefault(30000).withValidation(new Field.Validator[]{Field.RangeValidator.atLeast((Number)0)});
    private int batchSize;
    private String nullKey;
    private String nullValue;
    private String messageFormat;
    private int memoryThreshold;
    private int memoryLimitMb;
    private int batchDelay;
    private int bufferFillRate;

    public RedisStreamChangeConsumerConfig(Configuration config) {
        super(config, PROP_PREFIX);
    }

    protected void init(Configuration config) {
        super.init(config);
        this.batchSize = config.getInteger(PROP_BATCH_SIZE);
        this.nullKey = config.getString(PROP_NULL_KEY);
        this.nullValue = config.getString(PROP_NULL_VALUE);
        this.messageFormat = config.getString(PROP_MESSAGE_FORMAT);
        this.memoryLimitMb = config.getInteger(PROP_MEMORY_LIMIT_MB);
        this.bufferFillRate = config.getInteger(PROP_BUFFER_FILL_RATE);
    }

    protected List<Field> getAllConfigurationFields() {
        List fields = Collect.arrayListOf((Object)PROP_BATCH_SIZE, (Object[])new Field[]{PROP_NULL_KEY, PROP_NULL_VALUE, PROP_MESSAGE_FORMAT});
        fields.addAll(super.getAllConfigurationFields());
        return fields;
    }

    public int getBufferFillRate() {
        return this.bufferFillRate;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchDelay() {
        return this.batchDelay;
    }

    public String getNullKey() {
        return this.nullKey;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public int getMemoryLimitMb() {
        return this.memoryLimitMb;
    }
}

