/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.server.BaseChangeConsumer;
import io.debezium.server.redis.RedisMemoryThreshold;
import io.debezium.server.redis.RedisStreamChangeConsumerConfig;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.RedisConnection;
import io.debezium.util.DelayStrategy;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="redis")
@Dependent
public class RedisStreamChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisStreamChangeConsumer.class);
    private static final String DEBEZIUM_REDIS_SINK_CLIENT_NAME = "debezium:redis:sink";
    private static final String EXTENDED_MESSAGE_KEY_KEY = "key";
    private static final String EXTENDED_MESSAGE_VALUE_KEY = "value";
    private RedisClient client;
    private Function<ChangeEvent<Object, Object>, Map<String, String>> recordMapFunction;
    private RedisMemoryThreshold redisMemoryThreshold;
    private RedisStreamChangeConsumerConfig config;

    @PostConstruct
    void connect() {
        Configuration configuration = Configuration.from((Map)this.getConfigSubset(ConfigProvider.getConfig(), ""));
        this.config = new RedisStreamChangeConsumerConfig(configuration);
        String messageFormat = this.config.getMessageFormat();
        if ("extended".equals(messageFormat)) {
            this.recordMapFunction = record -> {
                LinkedHashMap<String, String> recordMap = new LinkedHashMap<String, String>();
                String key = record.key() != null ? this.getString(record.key()) : this.config.getNullKey();
                String value = record.value() != null ? this.getString(record.value()) : this.config.getNullValue();
                Map headers = this.convertHeaders((ChangeEvent)record);
                recordMap.put(EXTENDED_MESSAGE_KEY_KEY, key);
                recordMap.put(EXTENDED_MESSAGE_VALUE_KEY, value);
                for (Map.Entry entry : headers.entrySet()) {
                    recordMap.put(((String)entry.getKey()).toUpperCase(Locale.ROOT), (String)entry.getValue());
                }
                return recordMap;
            };
        } else if ("compact".equals(messageFormat)) {
            this.recordMapFunction = record -> {
                String key = record.key() != null ? this.getString(record.key()) : this.config.getNullKey();
                String value = record.value() != null ? this.getString(record.value()) : this.config.getNullValue();
                return Map.of(key, value);
            };
        }
        RedisConnection redisConnection = new RedisConnection(this.config.getAddress(), this.config.getDbIndex(), this.config.getUser(), this.config.getPassword(), this.config.getConnectionTimeout().intValue(), this.config.getSocketTimeout().intValue(), this.config.isSslEnabled());
        this.client = redisConnection.getRedisClient(DEBEZIUM_REDIS_SINK_CLIENT_NAME, this.config.isWaitEnabled(), this.config.getWaitTimeout(), this.config.isWaitRetryEnabled(), this.config.getWaitRetryDelay());
        this.redisMemoryThreshold = new RedisMemoryThreshold(this.client, this.config);
    }

    @PreDestroy
    void close() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while closing Jedis: {}", (Object)this.client, (Object)e);
        }
        finally {
            this.client = null;
        }
    }

    private <T> Stream<List<T>> batches(List<T> source, int length) {
        if (source.isEmpty()) {
            return Stream.empty();
        }
        int size = source.size();
        int fullChunks = (size - 1) / length;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * length, n == fullChunks ? size : (n + 1) * length));
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        DelayStrategy delayStrategy = DelayStrategy.exponential((Duration)Duration.ofMillis(this.config.getInitialRetryDelay().intValue()), (Duration)Duration.ofMillis(this.config.getMaxRetryDelay().intValue()));
        DelayStrategy delayStrategyOnRecordsConsumption = DelayStrategy.constant((Duration)Duration.ofMillis(this.config.getWaitRetryDelay()));
        LOGGER.debug("Handling a batch of {} records", (Object)records.size());
        this.batches(records, this.config.getBatchSize()).forEach(batch -> {
            boolean completedSuccessfully = false;
            List clonedBatch = batch.stream().collect(Collectors.toList());
            while (!completedSuccessfully) {
                block14: {
                    if (this.client == null) {
                        try {
                            this.connect();
                            continue;
                        }
                        catch (Exception e) {
                            this.close();
                            LOGGER.error("Can't connect to Redis", (Throwable)e);
                            break block14;
                        }
                    }
                    try {
                        LOGGER.debug("Preparing a Redis Pipeline of {} records", (Object)clonedBatch.size());
                        ArrayList<AbstractMap.SimpleEntry<String, Map<String, String>>> recordsMap = new ArrayList<AbstractMap.SimpleEntry<String, Map<String, String>>>(clonedBatch.size());
                        for (ChangeEvent record : clonedBatch) {
                            String destination = this.streamNameMapper.map(record.destination());
                            Map<String, String> recordMap = this.recordMapFunction.apply((ChangeEvent<Object, Object>)record);
                            recordsMap.add(new AbstractMap.SimpleEntry<String, Map<String, String>>(destination, recordMap));
                        }
                        if (recordsMap.size() == 0) continue;
                        if (!this.redisMemoryThreshold.checkMemory(RedisStreamChangeConsumer.getObjectSize((AbstractMap.SimpleEntry)recordsMap.get(0)), recordsMap.size(), this.config.getBufferFillRate())) {
                            LOGGER.info("Stopped consuming records!\n");
                            delayStrategyOnRecordsConsumption.sleepWhen(true);
                            continue;
                        }
                        List responses = this.client.xadd(recordsMap);
                        ArrayList<ChangeEvent> processedRecords = new ArrayList<ChangeEvent>();
                        int index = 0;
                        int totalOOMResponses = 0;
                        for (String message : responses) {
                            if (message.contains("OOM command not allowed when used memory > 'maxmemory'")) {
                                ++totalOOMResponses;
                            } else {
                                ChangeEvent currentRecord = (ChangeEvent)clonedBatch.get(index);
                                committer.markProcessed((Object)currentRecord);
                                processedRecords.add(currentRecord);
                            }
                            ++index;
                        }
                        clonedBatch.removeAll(processedRecords);
                        if (totalOOMResponses > 0) {
                            LOGGER.info("Redis sink currently full, will retry ({} command(s) will be retried)", (Object)totalOOMResponses);
                        }
                        if (clonedBatch.size() == 0) {
                            completedSuccessfully = true;
                        }
                    }
                    catch (RedisClientConnectionException jce) {
                        LOGGER.error("Connection error", (Throwable)jce);
                        this.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected Exception", (Throwable)e);
                        throw new DebeziumException((Throwable)e);
                    }
                }
                delayStrategy.sleepWhen(!completedSuccessfully);
            }
        });
        committer.markBatchFinished();
    }

    private static long getObjectSize(AbstractMap.SimpleEntry<String, Map<String, String>> record) {
        long approximateSize = 0L;
        approximateSize += (long)record.getKey().getBytes().length;
        Map<String, String> value = record.getValue();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            approximateSize += (long)(entry.getKey().getBytes().length + entry.getValue().getBytes().length);
        }
        LOGGER.debug("Estimated record size is {}", (Object)approximateSize);
        return approximateSize;
    }
}

