/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.TestConfigSource;
import io.debezium.server.redis.TestUtils;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class RedisTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTestResourceLifecycleManager.class);
    static final String READY_MESSAGE = "Ready to accept connections";
    public static final int REDIS_PORT = 6379;
    public static final int HOST_PORT = 16379;
    public static final String REDIS_IMAGE = "redis";
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final FixedHostPortGenericContainer<?> container = new FixedHostPortGenericContainer("redis").withFixedExposedPort(16379, 6379);

    private static synchronized void start(boolean ignored) {
        if (!running.get()) {
            container.start();
            TestUtils.waitBoolean(() -> container.getLogs().contains(READY_MESSAGE));
            running.set(true);
        }
    }

    public Map<String, String> start() {
        RedisTestResourceLifecycleManager.start(true);
        container.followOutput((Consumer)new Slf4jLogConsumer(LOGGER));
        Testing.Files.delete((Path)TestConfigSource.OFFSET_STORE_PATH);
        Testing.Files.createTestingFile((Path)TestConfigSource.OFFSET_STORE_PATH);
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.sink.type", REDIS_IMAGE);
        params.put("debezium.sink.redis.address", RedisTestResourceLifecycleManager.getRedisContainerAddress());
        params.put("debezium.source.connector.class", "io.debezium.connector.postgresql.PostgresConnector");
        params.put("debezium.source.offset.flush.interval.ms", "0");
        params.put("debezium.source.topic.prefix", "testc");
        params.put("debezium.source.schema.include.list", "inventory");
        params.put("debezium.source.table.include.list", "inventory.customers,inventory.redis_test,inventory.redis_test2");
        params.put("debezium.transforms", "addheader");
        params.put("debezium.transforms.addheader.type", "org.apache.kafka.connect.transforms.InsertHeader");
        params.put("debezium.transforms.addheader.header", "headerKey");
        params.put("debezium.transforms.addheader.value.literal", "headerValue");
        return params;
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }

    public static void pause() {
        container.getDockerClient().pauseContainerCmd(container.getContainerId()).exec();
    }

    public static void unpause() {
        container.getDockerClient().unpauseContainerCmd(container.getContainerId()).exec();
    }

    public static String getRedisContainerAddress() {
        RedisTestResourceLifecycleManager.start(true);
        return String.format("%s:%d", container.getContainerIpAddress(), container.getMappedPort(6379));
    }
}

