/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryMetrics;
import io.debezium.server.redis.RedisSchemaHistory;
import io.debezium.server.redis.RedisSchemaHistoryTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.debezium.testing.testcontainers.MySqlTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.StreamEntry;

@QuarkusIntegrationTest
@TestProfile(value=RedisSchemaHistoryTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisSchemaHistoryIT {
    private static final String STREAM_NAME = "metadata:debezium:schema_history";
    private static final int INIT_HISTORY_SIZE = 16;
    protected static Jedis jedis;
    protected SchemaHistory history;

    @BeforeEach
    public void beforeEach() {
        this.history = new RedisSchemaHistory();
        this.history.configure(((Configuration.Builder)Configuration.create().with("schema.history.internal.redis.address", (Object)HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()))).build(), null, SchemaHistoryMetrics.NOOP, true);
        this.history.start();
    }

    @AfterEach
    public void afterEach() {
        if (this.history != null) {
            this.history.stop();
        }
    }

    @Test
    @FixFor(value={"DBZ-4771"})
    public void testSchemaHistoryIsSaved() {
        jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 16);
        List entries = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null);
        AssertionsForClassTypes.assertThat((int)entries.size()).isIn(new Object[]{16, 17});
        Assertions.assertTrue((boolean)entries.stream().anyMatch(item -> ((String)item.getFields().get("schema")).contains("CREATE TABLE `customers`")));
    }

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisConnectionRetry() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 1);
        Testing.print((Object)"Pausing container");
        RedisTestResourceLifecycleManager.pause();
        JdbcConnection connection = this.getMySqlConnection();
        connection.connect();
        Testing.print((Object)"Creating new redis_test table and inserting 5 records to it");
        connection.execute(new String[]{"CREATE TABLE IF NOT EXISTS inventory.redis_test (id INT PRIMARY KEY)"});
        Testing.print((Object)"Table created");
        connection.close();
        Testing.print((Object)"Sleeping for 2 seconds to flush records");
        Thread.sleep(2000L);
        Testing.print((Object)"Unpausing container");
        RedisTestResourceLifecycleManager.unpause();
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 17);
        List entries = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null);
        Assertions.assertEquals((int)17, (int)entries.size());
        Assertions.assertTrue((boolean)((String)((StreamEntry)entries.get(16)).getFields().get("schema")).contains("redis_test"));
    }

    private JdbcConnection getMySqlConnection() {
        Configuration config = ((Configuration.Builder)Configuration.create().with("database.user", "mysqluser").with("database.password", "mysqlpassword").with("database.dbname", "inventory").with("database.hostname", "localhost").with("database.port", (Object)MySqlTestResourceLifecycleManager.getContainer().getMappedPort(MySqlTestResourceLifecycleManager.PORT.intValue()))).with("driver.protocol", "tcp").build();
        String url = "jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=30000";
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(config);
        return new JdbcConnection(connectorConfig.getJdbcConfig(), JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=30000", (Field[])new Field[]{MySqlConnectorConfig.JDBC_PROTOCOL}), "`", "`");
    }
}

