/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.redis.RedisSSLStreamTestProfile;
import io.debezium.server.redis.RedisSSLTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;

@QuarkusIntegrationTest
@TestProfile(value=RedisSSLStreamTestProfile.class)
public class RedisSSLStreamIT {
    @Test
    public void testRedisStream() throws Exception {
        HostAndPort address = HostAndPort.from((String)RedisSSLTestResourceLifecycleManager.getRedisContainerAddress());
        Jedis jedis = new Jedis(address.getHost(), address.getPort(), true);
        int MESSAGE_COUNT = 4;
        String STREAM_NAME = "testc.inventory.customers";
        String HASH_NAME = "metadata:debezium:offsets";
        TestUtils.awaitStreamLengthGte(jedis, "testc.inventory.customers", 4);
        Long streamLength = jedis.xlen("testc.inventory.customers");
        Assert.assertTrue((String)"Redis Basic Stream Test Failed", (streamLength == 4L ? 1 : 0) != 0);
        TestUtils.awaitHashSizeGte(jedis, "metadata:debezium:offsets", 1);
        Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
        Assert.assertTrue((redisOffsets.size() > 0 ? 1 : 0) != 0);
        jedis.close();
    }
}

