/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.config.Configuration;
import io.debezium.server.redis.RedisMemoryThreshold;
import io.debezium.server.redis.RedisStreamChangeConsumerConfig;
import io.debezium.storage.redis.RedisClient;
import io.debezium.util.Collect;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class RedisMemoryThresholdTest {
    private static final String _5MB = String.valueOf(0x500000);
    private static final String _10MB = String.valueOf(0xA00000);
    private static final String _20MB = String.valueOf(0x1400000);
    private static final long RECORD_SIZE = 2048L;
    private static final int BUFFER_SIZE = 500;
    private static final int RATE_PER_SECOND = 1000;

    @Test
    public void testMemoryLimits() {
        Configuration config = Configuration.from((Map)Collect.hashMapOf((Object)"debezium.sink.redis.address", (Object)"localhost", (Object)"debezium.sink.redis.rate.per.second", (Object)1000));
        RedisMemoryThreshold redisMemoryThreshold = new RedisMemoryThreshold((RedisClient)new RedisClientImpl(_10MB, _20MB), new RedisStreamChangeConsumerConfig(config));
        for (int i = 0; i < 8; ++i) {
            Assert.assertEquals((Object)redisMemoryThreshold.checkMemory(2048L, 500, 1000), (Object)true);
        }
        Assert.assertEquals((Object)redisMemoryThreshold.checkMemory(2048L, 500, 1000), (Object)false);
        redisMemoryThreshold.setRedisClient((RedisClient)new RedisClientImpl(_5MB, _20MB));
        Assert.assertEquals((Object)redisMemoryThreshold.checkMemory(2048L, 500, 1000), (Object)true);
    }

    private static class RedisClientImpl
    implements RedisClient {
        private String infoMemory;

        private RedisClientImpl(String usedMemoryBytes, String maxMemoryBytes) {
            this.infoMemory = (String)(usedMemoryBytes == null ? "" : "used_memory:" + usedMemoryBytes + "\n") + (String)(maxMemoryBytes == null ? "" : "maxmemory:" + maxMemoryBytes);
        }

        public String info(String section) {
            return this.infoMemory;
        }

        public void disconnect() {
        }

        public void close() {
        }

        public String xadd(String key, Map<String, String> hash) {
            return null;
        }

        public List<String> xadd(List<AbstractMap.SimpleEntry<String, Map<String, String>>> hashes) {
            return null;
        }

        public List<Map<String, String>> xrange(String key) {
            return null;
        }

        public long xlen(String key) {
            return 0L;
        }

        public Map<String, String> hgetAll(String key) {
            return null;
        }

        public long hset(byte[] key, byte[] field, byte[] value) {
            return 0L;
        }

        public long waitReplicas(int replicas, long timeout) {
            return 0L;
        }

        public String clientList() {
            return null;
        }
    }
}

