/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.server.redis.RedisStreamMemoryThresholdTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;

@QuarkusIntegrationTest
@TestProfile(value=RedisStreamMemoryThresholdTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisStreamMemoryThresholdIT {
    @Test
    public void testRedisMemoryThreshold() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        String STREAM_NAME = "testc.inventory.redis_test2";
        int TOTAL_RECORDS = 50;
        Testing.print((Object)"Setting Redis' maxmemory to 1M");
        jedis.configSet("maxmemory", "1M");
        PostgresConnection connection = TestUtils.getPostgresConnection();
        connection.execute(new String[]{"CREATE TABLE inventory.redis_test2 (id VARCHAR(100) PRIMARY KEY, first_name VARCHAR(100), last_name VARCHAR(100))"});
        connection.execute(new String[]{String.format("INSERT INTO inventory.redis_test2 (id,first_name,last_name) SELECT LEFT(i::text, 10), RANDOM()::text, RANDOM()::text FROM generate_series(1,%d) s(i)", 50)});
        connection.commit();
        Thread.sleep(1000L);
        Testing.print((Object)("Entries in testc.inventory.redis_test2:" + jedis.xlen("testc.inventory.redis_test2")));
        Assert.assertTrue((jedis.xlen("testc.inventory.redis_test2") < 50L ? 1 : 0) != 0);
        Thread.sleep(1000L);
        jedis.configSet("maxmemory", "0");
        TestUtils.awaitStreamLengthGte(jedis, "testc.inventory.redis_test2", 50);
        long streamLength = jedis.xlen("testc.inventory.redis_test2");
        Assert.assertTrue((String)"Redis Memory Threshold Test Failed", (streamLength == 50L ? 1 : 0) != 0);
    }
}

