/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.redis.RedisStreamMessageTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.StreamEntry;

@QuarkusIntegrationTest
@TestProfile(value=RedisStreamMessageTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisStreamMessageIT {
    @Test
    public void testRedisStreamExtendedMessage() {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        int MESSAGE_COUNT = 4;
        String STREAM_NAME = "testc.inventory.customers";
        TestUtils.awaitStreamLengthGte(jedis, "testc.inventory.customers", 4);
        long streamLength = jedis.xlen("testc.inventory.customers");
        Assertions.assertEquals((long)4L, (long)streamLength, (String)"Expected stream length of 4");
        List entries = jedis.xrange("testc.inventory.customers", (StreamEntryID)null, (StreamEntryID)null);
        for (StreamEntry entry : entries) {
            Map map = entry.getFields();
            Assertions.assertEquals((int)3, (int)map.size(), (String)"Expected map of size 3");
            Assertions.assertTrue((map.get("key") != null && ((String)map.get("key")).startsWith("{\"schema\":") ? 1 : 0) != 0, (String)"Expected key's value starting with {\"schema\":...");
            Assertions.assertTrue((map.get("value") != null && ((String)map.get("value")).startsWith("{\"schema\":") ? 1 : 0) != 0, (String)"Expected value's value starting with {\"schema\":...");
            Assertions.assertTrue((boolean)map.containsKey("HEADERKEY"));
        }
        jedis.close();
    }
}

