/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.doc.FixFor;
import io.debezium.server.redis.RedisOffsetTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;

@QuarkusIntegrationTest
@TestProfile(value=RedisOffsetTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisOffsetIT {
    private static final int MESSAGE_COUNT = 4;
    private static final String STREAM_NAME = "testc.inventory.customers";
    private static final String OFFSETS_HASH_NAME = "metadata:debezium:offsets";
    protected static Jedis jedis;

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisStream() throws Exception {
        jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 4);
        Map redisOffsets = jedis.hgetAll(OFFSETS_HASH_NAME);
        Assertions.assertThat((redisOffsets.size() > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisConnectionRetry() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        TestUtils.awaitHashSizeGte(jedis, OFFSETS_HASH_NAME, 1);
        jedis.del(OFFSETS_HASH_NAME);
        Testing.print((Object)"Pausing container");
        RedisTestResourceLifecycleManager.pause();
        PostgresConnection connection = TestUtils.getPostgresConnection();
        Testing.print((Object)"Creating new redis_test table and inserting 5 records to it");
        connection.execute(new String[]{"CREATE TABLE inventory.redis_test (id INT PRIMARY KEY)", "INSERT INTO inventory.redis_test VALUES (1)", "INSERT INTO inventory.redis_test VALUES (2)", "INSERT INTO inventory.redis_test VALUES (3)", "INSERT INTO inventory.redis_test VALUES (4)", "INSERT INTO inventory.redis_test VALUES (5)"});
        connection.close();
        Testing.print((Object)"Sleeping for 2 seconds to flush records");
        Thread.sleep(2000L);
        Testing.print((Object)"Unpausing container");
        RedisTestResourceLifecycleManager.unpause();
        Testing.print((Object)"Sleeping for 2 seconds to reconnect to redis and write offset");
        TestUtils.awaitHashSizeGte(jedis, OFFSETS_HASH_NAME, 1);
        Map redisOffsets = jedis.hgetAll(OFFSETS_HASH_NAME);
        jedis.close();
        Assertions.assertThat((redisOffsets.size() > 0 ? 1 : 0) != 0).isTrue();
    }
}

