/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.config.Configuration;
import io.debezium.server.redis.RedisMemoryThreshold;
import io.debezium.server.redis.RedisStreamChangeConsumerConfig;
import io.debezium.storage.redis.RedisClient;
import io.debezium.util.Collect;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class RedisMemoryThresholdTest {
    private static final String _1MB = String.valueOf(0x100000);
    private static final String _2MB = String.valueOf(0x200000);
    private static final String _3MB = String.valueOf(0x300000);
    private static final String _4MB = String.valueOf(0x400000);

    @Test
    public void testThresholdPercentageDisabled() {
        int[] thresholdList = new int[]{0};
        int[] limitMbList = new int[]{0, 1, 2, 3, 4};
        String[] usedMemoryList = new String[]{"asd3f", "2048L", null, _1MB, _2MB, _3MB, _4MB};
        String[] maxMemoryList = new String[]{"asd3f", "2048L", null, "0", _1MB, _2MB, _3MB, _4MB};
        for (int threshold : thresholdList) {
            for (int limit : limitMbList) {
                for (String used : usedMemoryList) {
                    for (String max : maxMemoryList) {
                        this.isMemoryOk(threshold, limit, used, max, true);
                    }
                }
            }
        }
    }

    @Test
    public void testUsedMemoryBad() {
        int[] thresholdList = new int[]{1, 24, 25, 26, 49, 50, 52, 74, 75, 76, 99, 100};
        int[] limitMbList = new int[]{0, 1, 2, 3, 4};
        String[] usedMemoryList = new String[]{"asd3f", "2048L"};
        String[] maxMemoryList = new String[]{"asd3f", "2048L", null, "0", _1MB, _2MB, _3MB, _4MB};
        for (int threshold : thresholdList) {
            for (int limit : limitMbList) {
                for (String used : usedMemoryList) {
                    for (String max : maxMemoryList) {
                        this.isMemoryOk(threshold, limit, used, max, true);
                    }
                }
            }
        }
    }

    @Test
    public void testUsedMemoryNotReported() {
        int[] thresholdList = new int[]{1, 24, 25, 26, 49, 50, 52, 74, 75, 76, 99, 100};
        int[] limitMbList = new int[]{0, 1, 2, 3, 4};
        String[] usedMemoryList = new String[]{null};
        String[] maxMemoryList = new String[]{"asd3f", "2048L", null, "0", _1MB, _2MB, _3MB, _4MB};
        for (int threshold : thresholdList) {
            for (int limit : limitMbList) {
                for (String used : usedMemoryList) {
                    for (String max : maxMemoryList) {
                        this.isMemoryOk(threshold, limit, used, max, true);
                    }
                }
            }
        }
    }

    @Test
    public void testMemoryLimit() {
        int[] thresholdList = new int[]{1, 24, 25, 26, 49, 50, 52, 74, 75, 76, 99, 100};
        int[] limitMbList = new int[]{0, 1, 2, 3, 4};
        String[] usedMemoryList = new String[]{_1MB, _2MB, _3MB, _4MB};
        String[] maxMemoryList = new String[]{"asd3f", "2048L", null, "0"};
        for (int threshold : thresholdList) {
            for (int limit : limitMbList) {
                for (String used : usedMemoryList) {
                    for (String max : maxMemoryList) {
                        this.isMemoryOk(threshold, limit, used, max, 0 == limit ? true : Long.parseLong(used) * 100L / (long)(limit * 1024 * 1024) < (long)threshold);
                    }
                }
            }
        }
    }

    @Test
    public void testMaxMemory() {
        int[] thresholdList = new int[]{1, 24, 25, 26, 49, 50, 52, 74, 75, 76, 99, 100};
        int[] limitMbList = new int[]{0, 1, 2, 3, 4};
        String[] usedMemoryList = new String[]{_1MB, _2MB, _3MB, _4MB};
        String[] maxMemoryList = new String[]{_1MB, _2MB, _3MB, _4MB};
        for (int threshold : thresholdList) {
            for (int limit : limitMbList) {
                for (String used : usedMemoryList) {
                    for (String max : maxMemoryList) {
                        this.isMemoryOk(threshold, limit, used, max, Long.parseLong(used) * 100L / Long.parseLong(max) < (long)threshold);
                    }
                }
            }
        }
    }

    private void isMemoryOk(int threshold, int memoryLimitMb, String usedMemoryBytes, String maxMemoryBytes, boolean expectedResult) {
        Configuration config = Configuration.from((Map)Collect.hashMapOf((Object)"debezium.sink.redis.address", (Object)"localhost", (Object)"debezium.sink.redis.memory.threshold.percentage", (Object)threshold, (Object)"debezium.sink.redis.memory.limit.mb", (Object)memoryLimitMb));
        RedisMemoryThreshold isMemoryOk = new RedisMemoryThreshold((RedisClient)new RedisClientImpl(usedMemoryBytes, maxMemoryBytes), new RedisStreamChangeConsumerConfig(config));
        Assert.assertEquals((String)String.format("isMemoryOk failed for threshold %s, limit %s, used %s, max %s)", threshold, memoryLimitMb, usedMemoryBytes, maxMemoryBytes), (Object)expectedResult, (Object)isMemoryOk.check());
    }

    private static class RedisClientImpl
    implements RedisClient {
        private String infoMemory;

        private RedisClientImpl(String usedMemoryBytes, String maxMemoryBytes) {
            this.infoMemory = (String)(usedMemoryBytes == null ? "" : "used_memory:" + usedMemoryBytes + "\n") + (String)(maxMemoryBytes == null ? "" : "maxmemory:" + maxMemoryBytes);
        }

        public String info(String section) {
            return this.infoMemory;
        }

        public void disconnect() {
        }

        public void close() {
        }

        public String xadd(String key, Map<String, String> hash) {
            return null;
        }

        public List<String> xadd(List<AbstractMap.SimpleEntry<String, Map<String, String>>> hashes) {
            return null;
        }

        public List<Map<String, String>> xrange(String key) {
            return null;
        }

        public long xlen(String key) {
            return 0L;
        }

        public Map<String, String> hgetAll(String key) {
            return null;
        }

        public long hset(byte[] key, byte[] field, byte[] value) {
            return 0L;
        }

        public long waitReplicas(int replicas, long timeout) {
            return 0L;
        }
    }
}

