/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.server.TestConfigSource;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import java.time.Duration;
import java.util.function.Supplier;
import org.awaitility.Awaitility;
import redis.clients.jedis.Jedis;

public class TestUtils {
    private TestUtils() {
    }

    public static PostgresConnection getPostgresConnection() {
        return new PostgresConnection((JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.create().with("user", "postgres")).with("password", "postgres")).with("dbname", "postgres")).with("hostname", "localhost")).with("port", (Object)PostgresTestResourceLifecycleManager.getContainer().getMappedPort(PostgresTestResourceLifecycleManager.POSTGRES_PORT.intValue()))).build(), "Debezium Redis Test");
    }

    public static void awaitStreamLengthGte(Jedis jedis, String streamName, int expectedLength) {
        TestUtils.waitBoolean(() -> jedis.xlen(streamName) >= (long)expectedLength);
    }

    public static void awaitHashSizeGte(Jedis jedis, String hashName, int expectedSize) {
        TestUtils.waitBoolean(() -> jedis.hgetAll(hashName).size() >= expectedSize);
    }

    private static void waitBoolean(Supplier<Boolean> bool) {
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> Boolean.TRUE.equals(bool.get()));
    }
}

