/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.redis.RedisStreamMessageTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.StreamEntry;

@QuarkusIntegrationTest
@TestProfile(value=RedisStreamMessageTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisStreamMessageIT {
    @Test
    public void testRedisStreamExtendedMessage() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        int MESSAGE_COUNT = 4;
        String STREAM_NAME = "testc.inventory.customers";
        TestUtils.awaitStreamLengthGte(jedis, "testc.inventory.customers", 4);
        Long streamLength = jedis.xlen("testc.inventory.customers");
        Assert.assertTrue((String)"Expected stream length of 4", (streamLength == 4L ? 1 : 0) != 0);
        List entries = jedis.xrange("testc.inventory.customers", (StreamEntryID)null, (StreamEntryID)null);
        for (StreamEntry entry : entries) {
            Map map = entry.getFields();
            Assert.assertTrue((String)"Expected map of size 2", (map.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Expected key's value starting with {\"schema\":...", (map.get("key") != null && ((String)map.get("key")).startsWith("{\"schema\":") ? 1 : 0) != 0);
            Assert.assertTrue((String)"Expected values's value starting with {\"schema\":...", (map.get("value") != null && ((String)map.get("value")).startsWith("{\"schema\":") ? 1 : 0) != 0);
        }
        jedis.close();
    }
}

