/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.doc.FixFor;
import io.debezium.relational.history.AbstractSchemaHistoryTest;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryMetrics;
import io.debezium.server.redis.RedisSchemaHistory;
import io.debezium.server.redis.RedisSchemaHistoryTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.server.redis.TestUtils;
import io.debezium.testing.testcontainers.MySqlTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.StreamEntry;

@QuarkusIntegrationTest
@TestProfile(value=RedisSchemaHistoryTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisSchemaHistoryIT
extends AbstractSchemaHistoryTest {
    private static final String STREAM_NAME = "metadata:debezium:schema_history";
    private static final int INIT_HISTORY_SIZE = 16;
    protected static Jedis jedis;

    @BeforeEach
    public void beforeEach() {
        super.beforeEach();
    }

    protected SchemaHistory createHistory() {
        RedisSchemaHistory history = new RedisSchemaHistory();
        history.configure(((Configuration.Builder)Configuration.create().with("schema.history.internal.redis.address", (Object)HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()))).build(), null, SchemaHistoryMetrics.NOOP, true);
        history.start();
        return history;
    }

    @Test
    @FixFor(value={"DBZ-4771"})
    public void testSchemaHistoryIsSaved() {
        jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 17);
        List entries = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null);
        Assertions.assertEquals((int)17, (int)entries.size());
        Assertions.assertTrue((boolean)entries.stream().anyMatch(item -> ((String)item.getFields().get("schema")).contains("CREATE TABLE `customers`")));
    }

    @Test
    @FixFor(value={"DBZ-4771"})
    public void shouldRecordChangesAndRecoverToVariousPoints() {
        super.shouldRecordChangesAndRecoverToVariousPoints();
    }

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisConnectionRetry() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 1);
        Testing.print((Object)"Pausing container");
        RedisTestResourceLifecycleManager.pause();
        MySqlConnection connection = this.getMySqlConnection();
        connection.connect();
        Testing.print((Object)"Creating new redis_test table and inserting 5 records to it");
        connection.execute(new String[]{"CREATE TABLE inventory.redis_test (id INT PRIMARY KEY)"});
        connection.close();
        Testing.print((Object)"Sleeping for 2 seconds to flush records");
        Thread.sleep(2000L);
        Testing.print((Object)"Unpausing container");
        RedisTestResourceLifecycleManager.unpause();
        TestUtils.awaitStreamLengthGte(jedis, STREAM_NAME, 17);
        List entries = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null);
        Assertions.assertEquals((int)17, (int)entries.size());
        Assertions.assertTrue((boolean)((String)((StreamEntry)entries.get(16)).getFields().get("schema")).contains("redis_test"));
    }

    private MySqlConnection getMySqlConnection() {
        return new MySqlConnection(new MySqlConnection.MySqlConnectionConfiguration(((Configuration.Builder)Configuration.create().with("database.user", "mysqluser").with("database.password", "mysqlpassword").with("database.dbname", "inventory").with("database.hostname", "localhost").with("database.port", (Object)MySqlTestResourceLifecycleManager.getContainer().getMappedPort(MySqlTestResourceLifecycleManager.PORT.intValue()))).build()));
    }
}

