/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.server.redis.RedisConnection;
import io.debezium.util.Collect;
import io.debezium.util.DelayStrategy;
import io.debezium.util.Throwables;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.resps.StreamEntry;

@ThreadSafe
public final class RedisSchemaHistory
extends AbstractSchemaHistory {
    private static final String CONFIGURATION_FIELD_PREFIX_STRING = "schema.history.internal.redis.";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSchemaHistory.class);
    public static final Field PROP_ADDRESS = Field.create((String)"schema.history.internal.redis.address").withDescription("The redis url that will be used to access the database schema history");
    public static final Field PROP_SSL_ENABLED = Field.create((String)"schema.history.internal.redis.ssl.enabled").withDescription("Use SSL for Redis connection").withDefault("false");
    public static final Field PROP_USER = Field.create((String)"schema.history.internal.redis.user").withDescription("The redis url that will be used to access the database schema history");
    public static final Field PROP_PASSWORD = Field.create((String)"schema.history.internal.redis.password").withDescription("The redis url that will be used to access the database schema history");
    public static final Field PROP_KEY = Field.create((String)"schema.history.internal.redis.key").withDescription("The redis key that will be used to store the database schema history").withDefault("metadata:debezium:schema_history");
    public static final Integer DEFAULT_RETRY_INITIAL_DELAY = 300;
    public static final Field PROP_RETRY_INITIAL_DELAY = Field.create((String)"schema.history.internal.redis.retry.initial.delay.ms").withDescription("Initial retry delay (in ms)").withDefault(DEFAULT_RETRY_INITIAL_DELAY.intValue());
    public static final Integer DEFAULT_RETRY_MAX_DELAY = 10000;
    public static final Field PROP_RETRY_MAX_DELAY = Field.create((String)"schema.history.internal.redis.retry.max.delay.ms").withDescription("Maximum retry delay (in ms)").withDefault(DEFAULT_RETRY_MAX_DELAY.intValue());
    public static final Integer DEFAULT_CONNECTION_TIMEOUT = 2000;
    public static final Field PROP_CONNECTION_TIMEOUT = Field.create((String)"schema.history.internal.redis.connection.timeout.ms").withDescription("Connection timeout (in ms)").withDefault(DEFAULT_CONNECTION_TIMEOUT.intValue());
    public static final Integer DEFAULT_SOCKET_TIMEOUT = 2000;
    public static final Field PROP_SOCKET_TIMEOUT = Field.create((String)"schema.history.internal.redis.socket.timeout.ms").withDescription("Socket timeout (in ms)").withDefault(DEFAULT_SOCKET_TIMEOUT.intValue());
    Duration initialRetryDelay;
    Duration maxRetryDelay;
    public static Collection<Field> ALL_FIELDS = Collect.arrayListOf((Object)PROP_ADDRESS, (Object[])new Field[]{PROP_USER, PROP_PASSWORD, PROP_KEY});
    private final DocumentWriter writer = DocumentWriter.defaultWriter();
    private final DocumentReader reader = DocumentReader.defaultReader();
    private final AtomicBoolean running = new AtomicBoolean();
    private Configuration config;
    private String redisKeyName;
    private String address;
    private String user;
    private String password;
    private boolean sslEnabled;
    private Integer connectionTimeout;
    private Integer socketTimeout;
    private Jedis client = null;

    void connect() {
        RedisConnection redisConnection = new RedisConnection(this.address, this.user, this.password, this.connectionTimeout, this.socketTimeout, this.sslEnabled);
        this.client = redisConnection.getRedisClient("debezium:schema_history");
    }

    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        if (!config.validateAndRecord(ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        this.config = config;
        this.address = this.config.getString(PROP_ADDRESS.name());
        this.user = this.config.getString(PROP_USER.name());
        this.password = this.config.getString(PROP_PASSWORD.name());
        this.sslEnabled = Boolean.parseBoolean(this.config.getString(PROP_SSL_ENABLED.name()));
        this.redisKeyName = this.config.getString(PROP_KEY);
        LOGGER.info("rediskeyname:" + this.redisKeyName);
        this.initialRetryDelay = Duration.ofMillis(this.config.getInteger(PROP_RETRY_INITIAL_DELAY));
        this.maxRetryDelay = Duration.ofMillis(this.config.getInteger(PROP_RETRY_MAX_DELAY));
        this.connectionTimeout = this.config.getInteger(PROP_CONNECTION_TIMEOUT);
        this.socketTimeout = this.config.getInteger(PROP_SOCKET_TIMEOUT);
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
    }

    public synchronized void start() {
        super.start();
        LOGGER.info("Starting RedisSchemaHistory");
        this.connect();
    }

    protected void storeRecord(HistoryRecord record) throws SchemaHistoryException {
        String line;
        if (record == null) {
            return;
        }
        try {
            line = this.writer.write(record.document());
        }
        catch (IOException e) {
            Throwables.logErrorAndTraceRecord((Logger)LOGGER, (Object)record, (String)"Failed to convert record to string", (Throwable)e);
            throw new SchemaHistoryException("Unable to write database schema history record");
        }
        DelayStrategy delayStrategy = DelayStrategy.exponential((Duration)this.initialRetryDelay, (Duration)this.maxRetryDelay);
        boolean completedSuccessfully = false;
        while (!completedSuccessfully) {
            try {
                if (this.client == null) {
                    this.connect();
                }
                this.client.xadd(this.redisKeyName, (StreamEntryID)null, Collections.singletonMap("schema", line));
                LOGGER.trace("Record written to database schema history in redis: " + line);
                completedSuccessfully = true;
            }
            catch (JedisConnectionException jce) {
                LOGGER.warn("Attempting to reconnect to redis ");
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Writing to database schema history stream failed", (Throwable)e);
                LOGGER.warn("Will retry");
            }
            if (completedSuccessfully) continue;
            delayStrategy.sleepWhen(!completedSuccessfully);
        }
    }

    public void stop() {
        this.running.set(false);
        if (this.client != null) {
            this.client.disconnect();
        }
        super.stop();
    }

    protected synchronized void recoverRecords(Consumer<HistoryRecord> records) {
        DelayStrategy delayStrategy = DelayStrategy.exponential((Duration)this.initialRetryDelay, (Duration)this.maxRetryDelay);
        boolean completedSuccessfully = false;
        List entries = new ArrayList();
        while (!completedSuccessfully) {
            try {
                if (this.client == null) {
                    this.connect();
                }
                entries = this.client.xrange(this.redisKeyName, (StreamEntryID)null, (StreamEntryID)null);
                completedSuccessfully = true;
            }
            catch (JedisConnectionException jce) {
                LOGGER.warn("Attempting to reconnect to redis ");
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Reading from database schema history stream failed with " + e);
                LOGGER.warn("Will retry");
            }
            if (completedSuccessfully) continue;
            delayStrategy.sleepWhen(!completedSuccessfully);
        }
        for (StreamEntry item : entries) {
            try {
                records.accept(new HistoryRecord(this.reader.read((String)item.getFields().get("schema"))));
            }
            catch (IOException e) {
                LOGGER.error("Failed to convert record to string: {}", (Object)item, (Object)e);
                return;
            }
        }
    }

    public boolean storageExists() {
        return true;
    }

    public boolean exists() {
        return this.client != null && this.client.xlen(this.redisKeyName) > 0L;
    }
}

