/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.redis.RedisSSLTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.quarkus.test.junit.QuarkusTestProfile;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedisSSLStreamTestProfile
implements QuarkusTestProfile {
    public List<QuarkusTestProfile.TestResourceEntry> testResources() {
        return Arrays.asList(new QuarkusTestProfile.TestResourceEntry(PostgresTestResourceLifecycleManager.class), new QuarkusTestProfile.TestResourceEntry(RedisSSLTestResourceLifecycleManager.class));
    }

    public Map<String, String> getConfigOverrides() {
        HashMap<String, String> config = new HashMap<String, String>();
        URL keyStoreFile = RedisSSLStreamTestProfile.class.getClassLoader().getResource("ssl/client-keystore.p12");
        URL trustStoreFile = RedisSSLStreamTestProfile.class.getClassLoader().getResource("ssl/client-truststore.p12");
        config.put("javax.net.ssl.keyStore", keyStoreFile.getPath());
        config.put("javax.net.ssl.trustStore", trustStoreFile.getPath());
        config.put("javax.net.ssl.keyStorePassword", "secret");
        config.put("javax.net.ssl.trustStorePassword", "secret");
        config.put("debezium.source.offset.storage", "io.debezium.server.redis.RedisOffsetBackingStore");
        config.put("debezium.source.connector.class", "io.debezium.connector.postgresql.PostgresConnector");
        return config;
    }
}

