/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.server.TestConfigSource;
import io.debezium.server.redis.RedisSSLStreamTestProfile;
import io.debezium.server.redis.RedisSSLTestResourceLifecycleManager;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.time.Duration;
import java.util.Map;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;

@QuarkusIntegrationTest
@TestProfile(value=RedisSSLStreamTestProfile.class)
public class RedisSSLStreamIT {
    private Long getStreamLength(Jedis jedis, String streamName, int expectedLength) {
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> jedis.xlen(streamName) == (long)expectedLength);
        return jedis.xlen(streamName);
    }

    @Test
    public void testRedisStream() throws Exception {
        HostAndPort address = HostAndPort.from((String)RedisSSLTestResourceLifecycleManager.getRedisContainerAddress());
        Jedis jedis = new Jedis(address.getHost(), address.getPort(), true);
        int MESSAGE_COUNT = 4;
        String STREAM_NAME = "testc.inventory.customers";
        Long streamLength = this.getStreamLength(jedis, "testc.inventory.customers", 4);
        Assert.assertTrue((String)"Redis Basic Stream Test Failed", (streamLength == 4L ? 1 : 0) != 0);
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> {
            Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
            return redisOffsets.size() > 0;
        });
        Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
        Assert.assertTrue((redisOffsets.size() > 0 ? 1 : 0) != 0);
        jedis.close();
    }
}

