/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.server.TestConfigSource;
import io.debezium.server.redis.RedisOffsetTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.PostgresTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;

@QuarkusIntegrationTest
@TestProfile(value=RedisOffsetTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisOffsetIT {
    private static final int MESSAGE_COUNT = 4;
    private static final String STREAM_NAME = "testc.inventory.customers";
    protected static Jedis jedis;

    private PostgresConnection getPostgresConnection() {
        return new PostgresConnection((JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.create().with("user", "postgres")).with("password", "postgres")).with("dbname", "postgres")).with("hostname", "localhost")).with("port", (Object)PostgresTestResourceLifecycleManager.getContainer().getMappedPort(PostgresTestResourceLifecycleManager.POSTGRES_PORT.intValue()))).build(), "Debezium Redis Test");
    }

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisStream() throws Exception {
        jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        ArrayList entries = new ArrayList();
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> {
            List response = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null, 4);
            entries.addAll(response);
            return entries.size() >= 4;
        });
        Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
        Assertions.assertThat((redisOffsets.size() > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisConnectionRetry() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> {
            Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
            return redisOffsets.size() > 0;
        });
        jedis.del("metadata:debezium:offsets");
        Testing.print((Object)"Pausing container");
        RedisTestResourceLifecycleManager.pause();
        PostgresConnection connection = this.getPostgresConnection();
        Testing.print((Object)"Creating new redis_test table and inserting 5 records to it");
        connection.execute(new String[]{"CREATE TABLE inventory.redis_test (id INT PRIMARY KEY)", "INSERT INTO inventory.redis_test VALUES (1)", "INSERT INTO inventory.redis_test VALUES (2)", "INSERT INTO inventory.redis_test VALUES (3)", "INSERT INTO inventory.redis_test VALUES (4)", "INSERT INTO inventory.redis_test VALUES (5)"});
        connection.close();
        Testing.print((Object)"Sleeping for 2 seconds to flush records");
        Thread.sleep(2000L);
        Testing.print((Object)"Unpausing container");
        RedisTestResourceLifecycleManager.unpause();
        Testing.print((Object)"Sleeping for 2 seconds to reconnect to redis and write offset");
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> {
            Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
            return redisOffsets.size() > 0;
        });
        Map redisOffsets = jedis.hgetAll("metadata:debezium:offsets");
        jedis.close();
        Assertions.assertThat((redisOffsets.size() > 0 ? 1 : 0) != 0).isTrue();
    }
}

