/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.server.redis.RedisConnection;
import io.debezium.util.Collect;
import io.debezium.util.DelayStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.resps.StreamEntry;

@ThreadSafe
public final class RedisDatabaseHistory
extends AbstractDatabaseHistory {
    private static final String CONFIGURATION_FIELD_PREFIX_STRING = "database.history.redis.";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisDatabaseHistory.class);
    public static final Field PROP_ADDRESS = Field.create((String)"database.history.redis.address").withDescription("The redis url that will be used to access the database history");
    public static final Field PROP_SSL_ENABLED = Field.create((String)"database.history.redis.ssl.enabled").withDescription("Use SSL for Redis connection").withDefault("false");
    public static final Field PROP_USER = Field.create((String)"database.history.redis.user").withDescription("The redis url that will be used to access the database history");
    public static final Field PROP_PASSWORD = Field.create((String)"database.history.redis.password").withDescription("The redis url that will be used to access the database history");
    public static final Field PROP_KEY = Field.create((String)"database.history.redis.key").withDescription("The redis key that will be used to store the database history").withDefault("metadata:debezium:db_history");
    public static final Integer DEFAULT_RETRY_INITIAL_DELAY = 300;
    public static final Field PROP_RETRY_INITIAL_DELAY = Field.create((String)"database.history.redis.retry.initial.delay.ms").withDescription("Initial retry delay (in ms)").withDefault(DEFAULT_RETRY_INITIAL_DELAY.intValue());
    public static final Integer DEFAULT_RETRY_MAX_DELAY = 10000;
    public static final Field PROP_RETRY_MAX_DELAY = Field.create((String)"database.history.redis.retry.max.delay.ms").withDescription("Maximum retry delay (in ms)").withDefault(DEFAULT_RETRY_MAX_DELAY.intValue());
    Integer initialRetryDelay;
    Integer maxRetryDelay;
    public static Collection<Field> ALL_FIELDS = Collect.arrayListOf((Object)PROP_ADDRESS, (Object[])new Field[]{PROP_USER, PROP_PASSWORD, PROP_KEY});
    private static final String SINK_PROP_PREFIX = "debezium.sink.redis.";
    private final DocumentWriter writer = DocumentWriter.defaultWriter();
    private final DocumentReader reader = DocumentReader.defaultReader();
    private final AtomicBoolean running = new AtomicBoolean();
    private Configuration config;
    private String redisKeyName;
    private String address;
    private String user;
    private String password;
    private boolean sslEnabled;
    private Jedis client = null;

    void connect() {
        RedisConnection redisConnection = new RedisConnection(this.address, this.user, this.password, this.sslEnabled);
        this.client = redisConnection.getRedisClient("debezium:db_history");
    }

    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        if (!config.validateAndRecord(ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        config.validateAndRecord(ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0));
        this.config = config;
        this.address = this.config.getString(PROP_ADDRESS.name());
        if (this.address == null) {
            this.address = this.config.getString("debezium.sink.redis.address");
            this.user = this.config.getString("debezium.sink.redis.user");
            this.password = this.config.getString("debezium.sink.redis.password");
            this.sslEnabled = Boolean.parseBoolean(this.config.getString("debezium.sink.redis.ssl.enabled"));
        } else {
            this.user = this.config.getString(PROP_USER.name());
            this.password = this.config.getString(PROP_PASSWORD.name());
            this.sslEnabled = Boolean.parseBoolean(this.config.getString(PROP_SSL_ENABLED.name()));
        }
        this.redisKeyName = this.config.getString(PROP_KEY);
        LOGGER.info("rediskeyname:" + this.redisKeyName);
        this.initialRetryDelay = this.config.getInteger(PROP_RETRY_INITIAL_DELAY);
        this.maxRetryDelay = this.config.getInteger(PROP_RETRY_MAX_DELAY);
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
    }

    public synchronized void start() {
        super.start();
        LOGGER.info("Starting RedisDatabaseHistory");
        this.connect();
    }

    protected void storeRecord(HistoryRecord record) throws DatabaseHistoryException {
        String line;
        if (record == null) {
            return;
        }
        try {
            line = this.writer.write(record.document());
        }
        catch (IOException e) {
            LOGGER.error("Failed to convert record to string: {}", (Object)record, (Object)e);
            throw new DatabaseHistoryException("Unable to write database history record");
        }
        DelayStrategy delayStrategy = DelayStrategy.exponential((long)this.initialRetryDelay.intValue(), (long)this.maxRetryDelay.intValue());
        boolean completedSuccessfully = false;
        while (!completedSuccessfully) {
            try {
                if (this.client == null) {
                    this.connect();
                }
                this.client.xadd(this.redisKeyName, (StreamEntryID)null, Collections.singletonMap("schema", line));
                LOGGER.trace("Record written to database history in redis: " + line);
                completedSuccessfully = true;
            }
            catch (JedisConnectionException jce) {
                LOGGER.warn("Attempting to reconnect to redis ");
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Writing to database history stream failed", (Throwable)e);
                LOGGER.warn("Will retry");
            }
            if (completedSuccessfully) continue;
            delayStrategy.sleepWhen(!completedSuccessfully);
        }
    }

    public void stop() {
        this.running.set(false);
        if (this.client != null) {
            this.client.disconnect();
        }
        super.stop();
    }

    protected synchronized void recoverRecords(Consumer<HistoryRecord> records) {
        DelayStrategy delayStrategy = DelayStrategy.exponential((long)this.initialRetryDelay.intValue(), (long)this.maxRetryDelay.intValue());
        boolean completedSuccessfully = false;
        List entries = new ArrayList();
        while (!completedSuccessfully) {
            try {
                if (this.client == null) {
                    this.connect();
                }
                entries = this.client.xrange(this.redisKeyName, (StreamEntryID)null, (StreamEntryID)null);
                completedSuccessfully = true;
            }
            catch (JedisConnectionException jce) {
                LOGGER.warn("Attempting to reconnect to redis ");
                this.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Reading from database history stream failed with " + e);
                LOGGER.warn("Will retry");
            }
            if (completedSuccessfully) continue;
            delayStrategy.sleepWhen(!completedSuccessfully);
        }
        for (StreamEntry item : entries) {
            try {
                records.accept(new HistoryRecord(this.reader.read((String)item.getFields().get("schema"))));
            }
            catch (IOException e) {
                LOGGER.error("Failed to convert record to string: {}", (Object)item, (Object)e);
                return;
            }
        }
    }

    public boolean storageExists() {
        return true;
    }

    public boolean exists() {
        return this.client != null && this.client.xlen(this.redisKeyName) > 0L;
    }
}

