/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.doc.FixFor;
import io.debezium.relational.history.AbstractDatabaseHistoryTest;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryMetrics;
import io.debezium.server.TestConfigSource;
import io.debezium.server.redis.RedisDatabaseHistory;
import io.debezium.server.redis.RedisDatabaseHistoryTestProfile;
import io.debezium.server.redis.RedisTestResourceLifecycleManager;
import io.debezium.testing.testcontainers.MySqlTestResourceLifecycleManager;
import io.debezium.util.Testing;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.TestProfile;
import java.time.Duration;
import java.util.List;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.StreamEntry;

@QuarkusIntegrationTest
@TestProfile(value=RedisDatabaseHistoryTestProfile.class)
@QuarkusTestResource(value=RedisTestResourceLifecycleManager.class)
public class RedisDatabaseHistoryIT
extends AbstractDatabaseHistoryTest {
    private static final String STREAM_NAME = "metadata:debezium:db_history";
    protected static Jedis jedis;

    @BeforeEach
    public void beforeEach() {
        super.beforeEach();
    }

    protected DatabaseHistory createHistory() {
        RedisDatabaseHistory history = new RedisDatabaseHistory();
        history.configure(((Configuration.Builder)Configuration.create().with(RedisDatabaseHistory.PROP_ADDRESS, (Object)HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()))).build(), null, DatabaseHistoryMetrics.NOOP, true);
        history.start();
        return history;
    }

    @Test
    @FixFor(value={"DBZ-4771"})
    public void testDatabaseHistoryIsSaved() throws Exception {
        jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> {
            long streamLength = jedis.xlen(STREAM_NAME);
            return streamLength == 16L;
        });
        List entries = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entries.stream().anyMatch(item -> ((String)item.getFields().get("schema")).contains("CREATE TABLE `customers`")));
    }

    @Test
    @FixFor(value={"DBZ-4771"})
    public void shouldRecordChangesAndRecoverToVariousPoints() {
        super.shouldRecordChangesAndRecoverToVariousPoints();
    }

    @Test
    @FixFor(value={"DBZ-4509"})
    public void testRedisConnectionRetry() throws Exception {
        Testing.Print.enable();
        Jedis jedis = new Jedis(HostAndPort.from((String)RedisTestResourceLifecycleManager.getRedisContainerAddress()));
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> {
            long streamLength = jedis.xlen(STREAM_NAME);
            return streamLength > 0L;
        });
        jedis.del(STREAM_NAME);
        Testing.print((Object)"Pausing container");
        RedisTestResourceLifecycleManager.pause();
        MySqlConnection connection = this.getMySqlConnection();
        connection.connect();
        Testing.print((Object)"Creating new redis_test table and inserting 5 records to it");
        connection.execute(new String[]{"CREATE TABLE inventory.redis_test (id INT PRIMARY KEY)"});
        connection.close();
        Testing.print((Object)"Sleeping for 2 seconds to flush records");
        Thread.sleep(2000L);
        Testing.print((Object)"Unpausing container");
        RedisTestResourceLifecycleManager.unpause();
        Awaitility.await().atMost(Duration.ofSeconds(TestConfigSource.waitForSeconds())).until(() -> {
            long streamLength = jedis.xlen(STREAM_NAME);
            return streamLength > 0L;
        });
        List entries = jedis.xrange(STREAM_NAME, (StreamEntryID)null, (StreamEntryID)null);
        Testing.print((Object)entries);
        Assertions.assertThat((entries.size() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)((String)((StreamEntry)entries.get(0)).getFields().get("schema"))).contains("redis_test");
    }

    private MySqlConnection getMySqlConnection() {
        return new MySqlConnection(new MySqlConnection.MySqlConnectionConfiguration(((Configuration.Builder)Configuration.create().with("database.user", "mysqluser").with("database.password", "mysqlpassword").with("database.dbname", "inventory").with("database.hostname", "localhost").with("database.port", (Object)MySqlTestResourceLifecycleManager.getContainer().getMappedPort(MySqlTestResourceLifecycleManager.PORT.intValue()))).build()));
    }
}

