/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.redis;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testcontainers.containers.GenericContainer;

public class RedisTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final int REDIS_PORT = 6379;
    public static final String REDIS_IMAGE = "redis";
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final GenericContainer<?> container = new GenericContainer("redis").withExposedPorts(new Integer[]{6379});

    private static synchronized void start(boolean ignored) {
        if (!running.get()) {
            container.start();
            running.set(true);
        }
    }

    public Map<String, String> start() {
        RedisTestResourceLifecycleManager.start(true);
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        return params;
    }

    public void stop() {
        try {
            container.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        running.set(false);
    }

    public static String getRedisContainerAddress() {
        RedisTestResourceLifecycleManager.start(true);
        return String.format("%s:%d", container.getContainerIpAddress(), container.getFirstMappedPort());
    }
}

