/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.rabbitmq;

import io.debezium.server.rabbitmq.RabbitMqContainer;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class RabbitMqTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final int PORT = 5672;
    public static RabbitMqContainer container = new RabbitMqContainer();
    private static final AtomicBoolean running = new AtomicBoolean(false);

    private static synchronized void init() throws IOException, InterruptedException {
        if (!running.get()) {
            container.start();
            container.execInContainer(new String[]{"rabbitmq-plugins", "enable", "--all"});
            running.set(true);
        }
    }

    public Map<String, String> start() {
        try {
            RabbitMqTestResourceLifecycleManager.init();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.sink.rabbitmq.connection.host", container.getHost());
        params.put("debezium.sink.rabbitmq.connection.port", String.valueOf(RabbitMqTestResourceLifecycleManager.getPort()));
        return params;
    }

    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getPort() {
        return container.getMappedPort(5672);
    }
}

