/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ConnectionFactoryConfigurator;
import com.rabbitmq.stream.Environment;
import com.rabbitmq.stream.Producer;
import com.rabbitmq.stream.StreamException;
import io.debezium.DebeziumException;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.Header;
import io.debezium.server.BaseChangeConsumer;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="rabbitmqstream")
@Dependent
public class RabbitMqStreamNativeChangeConsumer
extends BaseChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqStreamNativeChangeConsumer.class);
    private static final String PROP_PREFIX = "debezium.sink.rabbitmqstream.";
    private static final String PROP_STREAM = "debezium.sink.rabbitmqstream.stream";
    private static final String PROP_CONNECTION_PREFIX = "debezium.sink.rabbitmqstream.connection.";
    @ConfigProperty(name="debezium.sink.rabbitmqstream.stream")
    Optional<String> stream;
    @ConfigProperty(name="debezium.sink.rabbitmqstream.ackTimeout", defaultValue="30000")
    int ackTimeout;
    @ConfigProperty(name="debezium.sink.rabbitmqstream.null.value", defaultValue="default")
    String nullValue;
    Environment environment;
    Producer producer;

    @PostConstruct
    void connect() {
        Config config = ConfigProvider.getConfig();
        ConnectionFactory factory = new ConnectionFactory();
        Map<String, String> configProperties = this.getConfigSubset(config, PROP_CONNECTION_PREFIX).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : entry.getValue().toString()));
        ConnectionFactoryConfigurator.load((ConnectionFactory)factory, configProperties, (String)"");
        LOGGER.info("Using connection to {}:{}", (Object)factory.getHost(), (Object)factory.getPort());
        try {
            this.environment = Environment.builder().host(factory.getHost()).port(factory.getPort()).build();
            if (this.stream.isEmpty()) {
                throw new DebeziumException("Mandatory configration option 'debezium.sink.rabbitmqstream.stream' is not provided");
            }
            LOGGER.info("Creating stream '{}'", (Object)this.stream.get());
            this.environment.streamCreator().stream(this.stream.get()).create();
            this.producer = this.environment.producerBuilder().confirmTimeout(Duration.ofSeconds(this.ackTimeout)).stream(this.stream.get()).build();
        }
        catch (StreamException | IllegalArgumentException e) {
            throw new DebeziumException(e);
        }
    }

    @PreDestroy
    void close() {
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            if (this.environment != null) {
                this.environment.close();
            }
        }
        catch (Exception e) {
            throw new DebeziumException((Throwable)e);
        }
    }

    public void handleBatch(List<ChangeEvent<Object, Object>> records, DebeziumEngine.RecordCommitter<ChangeEvent<Object, Object>> committer) throws InterruptedException {
        for (ChangeEvent<Object, Object> record : records) {
            LOGGER.trace("Received event '{}'", record);
            try {
                Object value = record.value() != null ? record.value() : this.nullValue;
                this.producer.send(this.producer.messageBuilder().addData(this.getBytes(value)).build(), confirmationStatus -> {});
            }
            catch (StreamException e) {
                throw new DebeziumException((Throwable)e);
            }
            committer.markProcessed(record);
        }
        LOGGER.trace("Sent messages");
        committer.markBatchFinished();
    }

    public boolean supportsTombstoneEvents() {
        return false;
    }

    private Map<String, Object> convertRabbitMqHeaders(ChangeEvent<Object, Object> record) {
        List headers = record.headers();
        HashMap<String, Object> rabbitMqHeaders = new HashMap<String, Object>();
        for (Header header : headers) {
            rabbitMqHeaders.put(header.getKey(), header.getValue());
        }
        return rabbitMqHeaders;
    }
}

